/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.ArrayList;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public abstract class TileEntityAbstractBLFurnace
extends TileEntityBasicInventory
implements ISidedInventory,
ITickable {
    private static final String NBT_BURN_TIME = "BurnTime";
    private static final String NBT_COOK_TIME = "CookTime";
    private static final String NBT_CUSTOM_NAME = "CustomName";
    private String customName;
    private ArrayList<FurnaceData> furnaceData = new ArrayList();
    private final int[] sideSlots;
    private final int[] bottomSlots;
    private final int[] inputSlots;
    private final int[] outputSlots;
    private final int[] fuelSlots;
    private final int[] fluxSlots;
    private int furnaceAmount;

    public TileEntityAbstractBLFurnace(String name, int furnaceAmount) {
        super(furnaceAmount * 4, name);
        this.furnaceAmount = furnaceAmount;
        IntStream.range(0, furnaceAmount).forEach(i -> this.furnaceData.add(new FurnaceData(i)));
        this.inputSlots = this.furnaceData.stream().flatMapToInt(data -> IntStream.of(data.getInputSlot())).toArray();
        this.outputSlots = this.furnaceData.stream().flatMapToInt(data -> IntStream.of(data.getOutputSlot())).toArray();
        this.fuelSlots = this.furnaceData.stream().flatMapToInt(data -> IntStream.of(data.getFuelSlot())).toArray();
        this.fluxSlots = this.furnaceData.stream().flatMapToInt(data -> IntStream.of(data.getFluxSlot())).toArray();
        this.bottomSlots = ArrayUtils.addAll((int[])this.outputSlots, (int[])this.fuelSlots);
        this.sideSlots = ArrayUtils.addAll((int[])this.fuelSlots, (int[])this.fluxSlots);
    }

    public static boolean isItemFlux(ItemStack itemstack) {
        return itemstack.func_77973_b() == ItemRegistry.ITEMS_MISC && itemstack.func_77952_i() == ItemMisc.EnumItemMisc.LIMESTONE_FLUX.getID();
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container." + super.func_70005_c_();
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setStackDisplayName(String name) {
        this.customName = name;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (FurnaceData data : this.furnaceData) {
            if (nbt.func_150297_b(NBT_BURN_TIME, 2) && nbt.func_150297_b(NBT_COOK_TIME, 2)) {
                data.furnaceBurnTime = nbt.func_74765_d(NBT_BURN_TIME);
                data.furnaceCookTime = nbt.func_74765_d(NBT_COOK_TIME);
            } else {
                data.furnaceBurnTime = nbt.func_74765_d(NBT_BURN_TIME + data.index);
                data.furnaceCookTime = nbt.func_74765_d(NBT_COOK_TIME + data.index);
            }
            data.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(data.getFuelSlot()));
        }
        if (nbt.func_150297_b(NBT_CUSTOM_NAME, 8)) {
            this.customName = nbt.func_74779_i(NBT_CUSTOM_NAME);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (FurnaceData data : this.furnaceData) {
            nbt.func_74777_a(NBT_BURN_TIME + data.index, (short)data.furnaceBurnTime);
            nbt.func_74777_a(NBT_COOK_TIME + data.index, (short)data.furnaceCookTime);
        }
        if (this.func_145818_k_()) {
            nbt.func_74778_a(NBT_CUSTOM_NAME, this.customName);
        }
        return nbt;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int index, int count) {
        return this.furnaceData.get(index).furnaceCookTime * count / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int index, int remainingTime) {
        FurnaceData data = this.furnaceData.get(index);
        if (data.currentItemBurnTime == 0) {
            data.currentItemBurnTime = 200;
        }
        return data.furnaceBurnTime * remainingTime / data.currentItemBurnTime;
    }

    public boolean isBurning(int index) {
        return this.furnaceData.get(index).furnaceBurnTime > 0;
    }

    public FurnaceData getFurnaceData(int index) {
        return this.furnaceData.get(index);
    }

    public void func_73660_a() {
        boolean isDirty = false;
        for (FurnaceData data : this.furnaceData) {
            boolean isBurning = this.isBurning(data.index);
            if (data.furnaceBurnTime > 0) {
                data.furnaceBurnTime = Math.max(0, data.furnaceBurnTime - 1);
            } else if (data.furnaceBurnTime < 0) {
                data.furnaceBurnTime = 0;
            }
            if (this.field_145850_b.field_72995_K) continue;
            ItemStack fuelStack = this.func_70301_a(data.getFuelSlot());
            if (data.furnaceBurnTime != 0 || !fuelStack.func_190926_b() && !this.func_70301_a(data.getInputSlot()).func_190926_b()) {
                if (data.furnaceBurnTime == 0 && this.canSmelt(data)) {
                    data.currentItemBurnTime = (data.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack));
                    if (data.furnaceBurnTime > 0) {
                        isDirty = true;
                        if (!fuelStack.func_190926_b()) {
                            ItemStack containerItem = fuelStack.func_77973_b().getContainerItem(fuelStack);
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190916_E() == 0) {
                                this.func_70299_a(data.getFuelSlot(), containerItem);
                            }
                        }
                    }
                }
                if (this.isBurning(data.index) && this.canSmelt(data)) {
                    ++data.furnaceCookTime;
                    if (data.furnaceCookTime == 200) {
                        data.furnaceCookTime = 0;
                        this.smeltItem(data);
                        isDirty = true;
                    }
                } else {
                    data.furnaceCookTime = 0;
                }
            }
            if (isBurning == data.furnaceBurnTime > 0) continue;
            isDirty = true;
            this.updateState(data.furnaceBurnTime > 0);
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt(FurnaceData data) {
        ItemStack inputStack = this.func_70301_a(data.getInputSlot());
        if (inputStack.func_190926_b()) {
            return false;
        }
        ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(inputStack);
        if (smeltingResult.func_190926_b()) {
            return false;
        }
        ItemStack outputStack = this.func_70301_a(data.getOutputSlot());
        if (outputStack.func_190926_b()) {
            return true;
        }
        if (!outputStack.func_77969_a(smeltingResult)) {
            return false;
        }
        int result = outputStack.func_190916_E() + smeltingResult.func_190916_E();
        return result <= this.func_70297_j_() && result <= outputStack.func_77976_d();
    }

    private void smeltItem(FurnaceData data) {
        if (this.canSmelt(data)) {
            ItemStack fluxStack;
            ItemStack inputStack = this.func_70301_a(data.getInputSlot());
            ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(inputStack);
            ItemStack outputStack = this.func_70301_a(data.getOutputSlot());
            if (outputStack.func_190926_b()) {
                this.func_70299_a(data.getOutputSlot(), smeltingResult.func_77946_l());
                outputStack = this.func_70301_a(data.getOutputSlot());
            } else if (outputStack.func_77973_b() == smeltingResult.func_77973_b()) {
                outputStack.func_190917_f(smeltingResult.func_190916_E());
            }
            if (ItemRegistry.isIngotFromOre(inputStack, outputStack) && !(fluxStack = this.func_70301_a(data.getFluxSlot())).func_190926_b()) {
                boolean useFlux;
                boolean bl = useFlux = this.field_145850_b.field_73012_v.nextInt(3) == 0;
                if (useFlux && outputStack.func_190916_E() + 1 <= this.func_70297_j_() && outputStack.func_190916_E() + 1 <= outputStack.func_77976_d()) {
                    outputStack.func_190917_f(1);
                }
                fluxStack.func_190918_g(1);
                if (fluxStack.func_190916_E() <= 0) {
                    this.func_70299_a(data.getFluxSlot(), ItemStack.field_190927_a);
                }
            }
            inputStack.func_190918_g(1);
            if (inputStack.func_190916_E() <= 0) {
                this.func_70299_a(data.getInputSlot(), ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.getOutputSlots().noneMatch(this.slotMatch(slot)) && (this.getFuelSlots().anyMatch(this.slotMatch(slot)) ? TileEntityFurnace.func_145954_b((ItemStack)itemstack) : this.getFluxSlots().noneMatch(this.slotMatch(slot)) || TileEntityAbstractBLFurnace.isItemFlux(itemstack));
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.bottomSlots : (side == EnumFacing.UP ? this.inputSlots : this.sideSlots);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && this.getFuelSlots().anyMatch(this.slotMatch(slot))) {
            return stack.func_77973_b() == Items.field_151133_ar;
        }
        return true;
    }

    private IntPredicate slotMatch(int slot) {
        return x -> x == slot;
    }

    private IntStream getOutputSlots() {
        return IntStream.of(this.outputSlots);
    }

    private IntStream getFuelSlots() {
        return IntStream.of(this.fuelSlots);
    }

    private IntStream getFluxSlots() {
        return IntStream.of(this.fluxSlots);
    }

    protected abstract void updateState(boolean var1);

    public int getFurnaceAmount() {
        return this.furnaceAmount;
    }

    public static class FurnaceData
    implements Cloneable {
        private int furnaceBurnTime;
        private int currentItemBurnTime;
        private int furnaceCookTime;
        private int index;

        public FurnaceData(int index) {
            this.index = index;
        }

        public int getFurnaceBurnTime() {
            return this.furnaceBurnTime;
        }

        public void setFurnaceBurnTime(int furnaceBurnTime) {
            this.furnaceBurnTime = furnaceBurnTime;
        }

        public int getCurrentItemBurnTime() {
            return this.currentItemBurnTime;
        }

        public void setCurrentItemBurnTime(int currentItemBurnTime) {
            this.currentItemBurnTime = currentItemBurnTime;
        }

        public int getFurnaceCookTime() {
            return this.furnaceCookTime;
        }

        public void setFurnaceCookTime(int furnaceCookTime) {
            this.furnaceCookTime = furnaceCookTime;
        }

        public final int getInputSlot() {
            return this.index * 4;
        }

        public final int getOutputSlot() {
            return this.getInputSlot() + 2;
        }

        public final int getFuelSlot() {
            return this.getInputSlot() + 1;
        }

        public final int getFluxSlot() {
            return this.getInputSlot() + 3;
        }

        public FurnaceData clone() {
            try {
                return (FurnaceData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

