/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.world.storage.location.LocationCragrockTower;
import thebetweenlands.common.world.storage.location.LocationGuarded;
import thebetweenlands.common.world.storage.location.LocationPortal;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class StorageRegistry {
    private static final BiMap<ResourceLocation, Class<? extends ILocalStorage>> STORAGE_MAP = HashBiMap.create();
    private static final Map<ResourceLocation, Factory<?>> FACTORIES = new HashMap();

    public static void preInit() {
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "location_storage"), LocationStorage.class, LocationStorage::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "cragrock_tower"), LocationCragrockTower.class, LocationCragrockTower::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "location_guarded"), LocationGuarded.class, LocationGuarded::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "portal"), LocationPortal.class, LocationPortal::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "spirit_tree"), LocationSpiritTree.class, LocationSpiritTree::new);
    }

    public static <T extends ILocalStorage> void register(ResourceLocation id, Class<T> cls, Factory<T> factory) {
        STORAGE_MAP.put((Object)id, cls);
        FACTORIES.put(id, factory);
    }

    public static Class<? extends ILocalStorage> getStorageType(ResourceLocation id) {
        return (Class)STORAGE_MAP.get((Object)id);
    }

    public static Factory<? extends ILocalStorage> getStorageFactory(ResourceLocation id) {
        return FACTORIES.get(id);
    }

    public static ResourceLocation getStorageId(Class<? extends ILocalStorage> storage) {
        return (ResourceLocation)STORAGE_MAP.inverse().get(storage);
    }

    public static interface Factory<T extends ILocalStorage> {
        public T create(IWorldStorage var1, StorageID var2, @Nullable LocalRegion var3);
    }
}

