/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.elixir.effects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;
import thebetweenlands.util.TranslationHelper;

public class ElixirEffect {
    public static final int VIAL_INFUSION_MAX_POTENCY = 5;
    private final String effectName;
    private final int effectID;
    private final ResourceLocation icon;
    private final int color;
    private List<ElixirAttributeModifier> elixirAttributeModifiers = new ArrayList<ElixirAttributeModifier>();
    private ElixirPotionEffect potionEffect;
    private ResourceLocation potionID;
    private boolean isAntiInfusion = false;

    public ElixirEffect(int id, String name) {
        this(id, name, null, 0);
    }

    public ElixirEffect(int id, String name, ResourceLocation icon) {
        this(id, name, icon, 0);
    }

    public ElixirEffect(int id, String name, int color) {
        this(id, name, null, color);
    }

    public ElixirEffect(int id, String name, ResourceLocation icon, int color) {
        this.effectID = id;
        this.effectName = name;
        this.icon = icon;
        this.color = color;
    }

    public PotionEffect createEffect(int duration, int strength) {
        return new PotionEffect(Potion.func_180142_b((String)this.potionID.toString()), duration, strength);
    }

    public void registerPotion(String name) {
        this.potionEffect = (ElixirPotionEffect)new ElixirPotionEffect(this, this.effectName, this.color, this.icon).setRegistryName("thebetweenlands", name);
        this.potionID = this.potionEffect.getRegistryName();
        for (ElixirAttributeModifier modifier : this.elixirAttributeModifiers) {
            this.potionEffect.func_111184_a(modifier.attribute, modifier.uuid, modifier.modifier, modifier.operation);
        }
    }

    public int getID() {
        return this.effectID;
    }

    public String getEffectName() {
        return this.effectName;
    }

    public ResourceLocation getIcon() {
        return this.potionEffect.icon;
    }

    protected boolean isReady(int ticks, int strength) {
        return true;
    }

    protected void performEffect(EntityLivingBase entity, int strength) {
    }

    protected void affectEntity(@Nullable Entity source, @Nullable Entity indirectSource, EntityLivingBase target, int amplifier, double health) {
    }

    protected boolean isInstant() {
        return false;
    }

    protected double getAttributeModifier(AttributeModifier attributeModifier, int strength) {
        return attributeModifier.func_111164_d() * (double)(strength + 1);
    }

    public ElixirEffect addAttributeModifier(IAttribute attribute, String uuid, double modifier, int operation) {
        if (this.potionEffect != null) {
            this.potionEffect.func_111184_a(attribute, uuid, modifier, operation);
        } else {
            this.elixirAttributeModifiers.add(new ElixirAttributeModifier(attribute, uuid, modifier, operation));
        }
        return this;
    }

    public ElixirEffect setAntiInfusion() {
        this.isAntiInfusion = true;
        return this;
    }

    public boolean isAntiInfusion() {
        return this.isAntiInfusion;
    }

    public boolean isActive(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_188419_a().getRegistryName() != this.potionID) continue;
            return true;
        }
        return false;
    }

    public int getDuration(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_188419_a().getRegistryName() != this.potionID) continue;
            return effect.func_76459_b();
        }
        return -1;
    }

    public int getStrength(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_188419_a().getRegistryName() != this.potionID) continue;
            return effect.func_76458_c();
        }
        return -1;
    }

    public PotionEffect getPotionEffect(EntityLivingBase entity) {
        if (entity.func_70644_a(Potion.func_180142_b((String)this.potionID.toString()))) {
            return entity.func_70660_b((Potion)this.potionEffect);
        }
        return null;
    }

    public void removeElixir(EntityLivingBase entity) {
        entity.func_184589_d(Potion.func_180142_b((String)this.potionID.toString()));
    }

    public ElixirPotionEffect getPotionEffect() {
        return this.potionEffect;
    }

    public static class ElixirPotionEffect
    extends Potion {
        private final ElixirEffect effect;
        private final ResourceLocation icon;
        @SideOnly(value=Side.CLIENT)
        private String localizedElixirName;
        @SideOnly(value=Side.CLIENT)
        private TextContainer nameContainer;

        protected ElixirPotionEffect(ElixirEffect effect, String unlocalizedName, int color, ResourceLocation icon) {
            super(false, color);
            this.func_76390_b(unlocalizedName);
            this.effect = effect;
            this.icon = icon;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76400_d() {
            return this.icon != null;
        }

        public boolean func_76403_b() {
            return this.effect.isInstant();
        }

        @SideOnly(value=Side.CLIENT)
        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            if (this.icon != null) {
                GlStateManager.func_179098_w();
                GlStateManager.func_179147_l();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.icon);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexBuffer = tessellator.func_178180_c();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexBuffer.func_181662_b((double)(x + 6), (double)(y + 6), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 6), (double)(y + 6 + 20), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 6 + 20), (double)(y + 6 + 20), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 6 + 20), (double)(y + 6), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
            if (this.localizedElixirName == null) {
                this.localizedElixirName = TranslationHelper.translateToLocal(this.func_76393_a(), new Object[0]);
            }
            if (this.nameContainer == null) {
                this.nameContainer = new TextContainer(88.0, 100.0, this.localizedElixirName, Minecraft.func_71410_x().field_71466_p);
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.localizedElixirName);
                float scale = 1.0f;
                if (width > 88) {
                    scale = 88.0f / (float)width;
                    scale -= scale % 0.25f;
                }
                if (scale < 0.5f) {
                    scale = 0.5f;
                }
                this.nameContainer.setCurrentScale(scale);
                this.nameContainer.setCurrentColor(-1);
                try {
                    this.nameContainer.parse();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.nameContainer != null && this.nameContainer.getPages().size() > 0) {
                this.func_76390_b("");
                TextContainer.TextPage page0 = this.nameContainer.getPages().get(0);
                page0.render(x + 28, y + 6);
                String s = Potion.func_188410_a((PotionEffect)effect, (float)1.0f);
                mc.field_71466_p.func_175063_a(s, (float)(x + 10 + 18), (float)(y + 6 + 10), 0x7F7F7F);
            }
        }

        public boolean shouldRenderInvText(PotionEffect effect) {
            return false;
        }

        public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
            if (this.icon != null) {
                GlStateManager.func_179098_w();
                GlStateManager.func_179147_l();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.icon);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexBuffer = tessellator.func_178180_c();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexBuffer.func_181662_b((double)(x + 2), (double)(y + 2), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 2), (double)(y + 2 + 20), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 2 + 20), (double)(y + 2 + 20), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 2 + 20), (double)(y + 2), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
        }

        public boolean func_76397_a(int ticks, int strength) {
            return this.effect.isReady(ticks, strength);
        }

        public void func_76394_a(EntityLivingBase entity, int strength) {
            this.effect.performEffect(entity, strength);
        }

        public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, EntityLivingBase target, int amplifier, double health) {
            this.effect.affectEntity(source, indirectSource, target, amplifier, health);
        }

        public double func_111183_a(int strength, AttributeModifier attributeModifier) {
            return this.effect.getAttributeModifier(attributeModifier, strength);
        }
    }

    private static class ElixirAttributeModifier {
        private final IAttribute attribute;
        private final String uuid;
        private final double modifier;
        private final int operation;

        private ElixirAttributeModifier(IAttribute attribute, String uuid, double modifier, int operation) {
            this.attribute = attribute;
            this.uuid = uuid;
            this.modifier = modifier;
            this.operation = operation;
        }
    }
}

