/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.elixir;

import java.util.ArrayList;
import java.util.List;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.registries.AspectRegistry;

public class ElixirRecipes {
    private static final List<ElixirRecipe> REGISTERED_RECIPES = new ArrayList<ElixirRecipe>();

    public static void registerRecipe(ElixirRecipe recipe) {
        REGISTERED_RECIPES.add(recipe);
    }

    public static ElixirRecipe getFromEffect(ElixirEffect effect) {
        for (ElixirRecipe recipe : REGISTERED_RECIPES) {
            if (recipe.positiveElixir != effect && recipe.negativeElixir != effect) continue;
            return recipe;
        }
        return null;
    }

    public static ElixirRecipe getFromAspects(List<IAspectType> aspects) {
        for (ElixirRecipe recipe : REGISTERED_RECIPES) {
            boolean matches = true;
            block1: for (IAspectType recipeAspect : recipe.aspects) {
                for (IAspectType aspect : aspects) {
                    if (aspect == AspectRegistry.BYARIIS || aspect == recipe.durationAspect || aspect == recipe.strengthAspect) continue;
                    boolean contains = false;
                    for (IAspectType a : recipe.aspects) {
                        if (a != aspect) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    matches = false;
                    break block1;
                }
                if (aspects.contains(recipeAspect)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return recipe;
        }
        return null;
    }

    public static List<ElixirRecipe> getFromAspect(IAspectType aspectType) {
        ArrayList<ElixirRecipe> recipes = new ArrayList<ElixirRecipe>();
        for (ElixirRecipe recipe : REGISTERED_RECIPES) {
            for (IAspectType recipeAspect : recipe.aspects) {
                if (recipeAspect != aspectType) continue;
                recipes.add(recipe);
            }
        }
        return recipes;
    }

    public static void init() {
        ElixirRecipes.registerRecipe(new ElixirRecipe("Elixir of Strength", -16776961, -65536, -13424382, 2000, 200, 2400, 10800, 240, 1200, ElixirEffectRegistry.EFFECT_STRENGTH, ElixirEffectRegistry.EFFECT_WEAKNESS, AspectRegistry.AZUWYNN, AspectRegistry.ORDANIIS, new IAspectType[]{AspectRegistry.AZUWYNN, AspectRegistry.ORDANIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Nimblefeet Elixir", -16776961, -5460240, -13424382, 2000, 200, 2400, 10800, 300, 2000, ElixirEffectRegistry.EFFECT_NIMBLEFEET, ElixirEffectRegistry.EFFECT_LUMBERING, AspectRegistry.YUNUGAZ, AspectRegistry.ORDANIIS, new IAspectType[]{AspectRegistry.AZUWYNN, AspectRegistry.ORDANIIS, AspectRegistry.YUNUGAZ}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Elixir of Healing", -16776961, -14887299, -13424382, 2000, 200, 1200, 6000, 160, 240, ElixirEffectRegistry.EFFECT_HEALING, ElixirEffectRegistry.EFFECT_DRAINING, AspectRegistry.YEOWYNN, AspectRegistry.ORDANIIS, new IAspectType[]{AspectRegistry.YEOWYNN, AspectRegistry.ORDANIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Elixir of Ripening", -16776961, -7488018, -13424382, 2000, 200, 2400, 15600, 400, 1200, ElixirEffectRegistry.EFFECT_RIPENING, ElixirEffectRegistry.EFFECT_DECAY, AspectRegistry.DAYUNIIS, AspectRegistry.ORDANIIS, new IAspectType[]{AspectRegistry.YEOWYNN, AspectRegistry.ORDANIIS, AspectRegistry.DAYUNIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Toughskin Elixir", -16776961, -12381775, -13424382, 2000, 200, 2400, 15600, 160, 240, ElixirEffectRegistry.EFFECT_TOUGHSKIN, ElixirEffectRegistry.EFFECT_POISONSTING, AspectRegistry.YEOWYNN, AspectRegistry.CELAWYNN, new IAspectType[]{AspectRegistry.AZUWYNN, AspectRegistry.YEOWYNN, AspectRegistry.CELAWYNN}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Elixir of Feasting", -16776961, -3837672, -13424382, 2000, 200, 2400, 13200, 400, 1200, ElixirEffectRegistry.EFFECT_FEASTING, ElixirEffectRegistry.EFFECT_STARVATION, AspectRegistry.CELAWYNN, AspectRegistry.ORDANIIS, new IAspectType[]{AspectRegistry.CELAWYNN, AspectRegistry.YEOWYNN, AspectRegistry.ORDANIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Hunter's Sense Brew", -16776961, -9496739, -13424382, 2000, 200, 3000, 12000, 400, 1200, ElixirEffectRegistry.EFFECT_HUNTERSSENSE, ElixirEffectRegistry.EFFECT_DRUNKARD, AspectRegistry.FREIWYNN, AspectRegistry.DAYUNIIS, new IAspectType[]{AspectRegistry.FREIWYNN, AspectRegistry.DAYUNIIS, AspectRegistry.ORDANIIS, AspectRegistry.FIRNALAZ}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Masking Brew", -16776961, -14103339, -13424382, 2000, 200, 2400, 15600, 600, 6000, ElixirEffectRegistry.EFFECT_MASKING, ElixirEffectRegistry.EFFECT_STENCHING, AspectRegistry.ARMANIIS, AspectRegistry.DAYUNIIS, new IAspectType[]{AspectRegistry.DAYUNIIS, AspectRegistry.ARMANIIS, AspectRegistry.BYARIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Swiftarm Brew", -16776961, -1508261, -13424382, 2000, 200, 2400, 10800, 200, 1200, ElixirEffectRegistry.EFFECT_SWIFTARM, ElixirEffectRegistry.EFFECT_SLUGARM, AspectRegistry.AZUWYNN, AspectRegistry.ORDANIIS, new IAspectType[]{AspectRegistry.AZUWYNN, AspectRegistry.DAYUNIIS, AspectRegistry.YUNUGAZ, AspectRegistry.ORDANIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Brew of the Cat's Eye", -16776961, -8738279, -13424382, 2000, 200, 2400, 9600, 160, 240, ElixirEffectRegistry.EFFECT_CATSEYES, ElixirEffectRegistry.EFFECT_BLINDMAN, AspectRegistry.FREIWYNN, AspectRegistry.DAYUNIIS, new IAspectType[]{AspectRegistry.FREIWYNN, AspectRegistry.DAYUNIIS, AspectRegistry.ORDANIIS, AspectRegistry.GEOLIIRGAZ}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Draught of Sagittarius", -16776961, -1415375, -13424382, 2000, 200, 3000, 12000, 400, 1200, ElixirEffectRegistry.EFFECT_SAGITTARIUS, ElixirEffectRegistry.EFFECT_WEAKBOW, AspectRegistry.FREIWYNN, AspectRegistry.DAYUNIIS, new IAspectType[]{AspectRegistry.FREIWYNN, AspectRegistry.DAYUNIIS, AspectRegistry.BYARIIS, AspectRegistry.ORDANIIS, AspectRegistry.ARMANIIS}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Spiderbreed Draught", -16776961, -9321936, -13424382, 2000, 200, 1200, 12000, 40, 200, ElixirEffectRegistry.EFFECT_SPIDERBREED, ElixirEffectRegistry.EFFECT_BASILISK, AspectRegistry.AZUWYNN, AspectRegistry.YIHINREN, new IAspectType[]{AspectRegistry.AZUWYNN, AspectRegistry.FERGALAZ, AspectRegistry.DAYUNIIS, AspectRegistry.YIHINREN, AspectRegistry.YUNUGAZ}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Lightweight Draught", -16776961, -10147622, -13424382, 2000, 200, 1200, 9600, 200, 1200, ElixirEffectRegistry.EFFECT_LIGHTWEIGHT, ElixirEffectRegistry.EFFECT_HEAVYWEIGHT, AspectRegistry.YUNUGAZ, AspectRegistry.YIHINREN, new IAspectType[]{AspectRegistry.AZUWYNN, AspectRegistry.BYRGINAZ, AspectRegistry.YUNUGAZ, AspectRegistry.GEOLIIRGAZ}));
        ElixirRecipes.registerRecipe(new ElixirRecipe("Draught of the Unclouded", -16776961, -15884833, -13424382, 2000, 200, 1200, 10800, 120, 240, ElixirEffectRegistry.EFFECT_UNCLOUDED, ElixirEffectRegistry.EFFECT_FOGGEDMIND, AspectRegistry.GEOLIIRGAZ, AspectRegistry.DAYUNIIS, new IAspectType[]{AspectRegistry.DAYUNIIS, AspectRegistry.FREIWYNN, AspectRegistry.GEOLIIRGAZ, AspectRegistry.ORDANIIS, AspectRegistry.YUNUGAZ}));
    }
}

