/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets.text;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;
import thebetweenlands.common.herblore.book.widgets.text.FormatTags;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;
import thebetweenlands.util.TranslationHelper;

@SideOnly(value=Side.CLIENT)
public class TextWidget
extends ManualWidgetBase {
    private TextContainer textContainer;
    private String text;
    private float scale = 1.0f;
    private int width;
    private int height;
    private int pageNumber = 0;

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String unlocalizedText) {
        super(xStart, yStart);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]), Minecraft.func_71410_x().field_71466_p);
        this.text = I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]);
        if (!I18n.func_188566_a((String)unlocalizedText) || this.text.equals("")) {
            TranslationHelper.addUnlocalizedString(unlocalizedText);
        }
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String unlocalizedText, int pageNumber) {
        super(xStart, yStart);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]), Minecraft.func_71410_x().field_71466_p);
        this.text = I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]);
        if (!I18n.func_188566_a((String)unlocalizedText) || this.text.equals("")) {
            TranslationHelper.addUnlocalizedString(unlocalizedText);
        }
        this.init();
        this.pageNumber = pageNumber;
    }

    public TextWidget(int xStart, int yStart, String unlocalizedText, int pageNumber, int width, int height) {
        super(xStart, yStart);
        this.width = width;
        this.height = height;
        this.textContainer = new TextContainer(width, height, I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]), Minecraft.func_71410_x().field_71466_p);
        this.text = I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]);
        if (!I18n.func_188566_a((String)unlocalizedText) || this.text.equals("")) {
            TranslationHelper.addUnlocalizedString(unlocalizedText);
        }
        this.init();
        this.pageNumber = pageNumber;
    }

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String unlocalizedText, float scale) {
        super(xStart, yStart);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]), Minecraft.func_71410_x().field_71466_p);
        this.text = I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]);
        if (!I18n.func_188566_a((String)unlocalizedText) || this.text.equals("")) {
            TranslationHelper.addUnlocalizedString(unlocalizedText);
        }
        this.scale = scale;
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String text, boolean isLocalized) {
        super(xStart, yStart);
        this.text = isLocalized ? text : I18n.func_135052_a((String)text, (Object[])new Object[0]);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, text, Minecraft.func_71410_x().field_71466_p);
        if (!(isLocalized || I18n.func_188566_a((String)text) && !text.equals(""))) {
            TranslationHelper.addUnlocalizedString(text);
        }
        this.init();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPageToRight() {
        super.setPageToRight();
        this.textContainer = new TextContainer(this.width, this.height, this.text, Minecraft.func_71410_x().field_71466_p);
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public void init() {
        this.textContainer.setCurrentScale(this.scale).setCurrentColor(0x808080);
        this.textContainer.registerTag(new FormatTags.TagNewLine());
        this.textContainer.registerTag(new FormatTags.TagNewPage());
        this.textContainer.registerTag(new FormatTags.TagScale(1.0f));
        this.textContainer.registerTag(new FormatTags.TagColor(0x808080));
        this.textContainer.registerTag(new FormatTags.TagTooltip("N/A"));
        this.textContainer.registerTag(new FormatTags.TagSimple("bold", TextFormatting.BOLD));
        this.textContainer.registerTag(new FormatTags.TagSimple("obfuscated", TextFormatting.OBFUSCATED));
        this.textContainer.registerTag(new FormatTags.TagSimple("italic", TextFormatting.ITALIC));
        this.textContainer.registerTag(new FormatTags.TagSimple("strikethrough", TextFormatting.STRIKETHROUGH));
        this.textContainer.registerTag(new FormatTags.TagSimple("underline", TextFormatting.UNDERLINE));
        this.textContainer.registerTag(new FormatTags.TagPagelink());
        this.textContainer.registerTag(new FormatTags.TagRainbow());
        this.textContainer.registerTag(new FormatTags.TagFont());
        try {
            this.textContainer.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        TextContainer.TextPage page = this.textContainer.getPages().get(this.pageNumber);
        page.render(this.xStart, this.yStart);
        page.renderTooltips(this.xStart, this.yStart, this.mouseX, this.mouseY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void resize() {
        super.resize();
        this.textContainer = new TextContainer(this.width, this.height, this.text, Minecraft.func_71410_x().field_71466_p);
        this.init();
    }

    public TextWidget setWidth(int width) {
        this.width = width;
        return this;
    }
}

