/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;
import thebetweenlands.util.AspectIconRenderer;

@SideOnly(value=Side.CLIENT)
public class AspectSlideShowWidget
extends ManualWidgetBase {
    public ItemStack itemStack;
    public ArrayList<IAspectType> aspects = new ArrayList();
    public int currentItems = 0;

    public AspectSlideShowWidget(int xStart, int yStart, ItemStack itemStack) {
        super(xStart, yStart);
        this.itemStack = itemStack;
    }

    public AspectSlideShowWidget(int xStart, int yStart, ArrayList<IAspectType> aspects) {
        super(xStart, yStart);
        this.aspects = aspects;
    }

    public AspectSlideShowWidget(int xStart, int yStart, IAspectType[] aspects) {
        super(xStart, yStart);
        Collections.addAll(this.aspects, aspects);
    }

    @Override
    public void drawForeGround() {
        List<IAspectType> subItems = this.aspects.subList(this.currentItems, this.currentItems + (this.aspects.size() - this.currentItems > 5 ? 6 : this.aspects.size() - this.currentItems));
        int width = 0;
        for (IAspectType aspect : subItems) {
            AspectIconRenderer.renderIcon(this.xStart + width, this.yStart, 16, 16, aspect.getIcon());
            ManualWidgetBase.PageLink link = new ManualWidgetBase.PageLink(this.xStart + width, this.yStart, 16, 16, aspect);
            if (link.category != null) {
                this.pageLinks.add(link);
            }
            if (this.mouseX >= this.xStart + width && this.mouseX <= this.xStart + 16 + width && this.mouseY >= this.yStart && this.mouseY <= this.yStart + 16) {
                ArrayList<String> tooltipData = new ArrayList<String>();
                tooltipData.add(aspect.getName());
                tooltipData.add(TextFormatting.GRAY + aspect.getType());
                tooltipData.add(TextFormatting.GRAY + (I18n.func_94522_b((String)"manual.open_entry") ? I18n.func_74838_a((String)"manual.open_entry") : I18n.func_150826_b((String)"manual.open_entry")));
                AspectSlideShowWidget.renderTooltip(this.mouseX, this.mouseY, tooltipData, 0xFFFFFF, -267386864);
            }
            width += 18;
        }
    }

    @Override
    public void resize() {
        super.resize();
        if (this.itemStack != null) {
            this.getAspects();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 20 == 0) {
            this.currentItems = this.currentItems + 1 < this.aspects.size() && this.aspects.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + 96 && y >= this.yStart && y <= this.yStart + 16) {
            this.currentItems = this.currentItems + 1 < this.aspects.size() && this.aspects.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    public void getAspects() {
        this.aspects.clear();
        ItemAspectContainer container = ItemAspectContainer.fromItem(this.itemStack, AspectManager.get((World)Minecraft.func_71410_x().field_71441_e));
        List<Aspect> visibleAspects = container.getAspects(DiscoveryContainer.getMergedDiscoveryContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        for (Aspect aspect : visibleAspects) {
            this.aspects.add(aspect.type);
        }
    }
}

