/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.api.network.IGenericDataManagerAccess;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageSyncEnvironmentEventData;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEvent;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EnvironmentEventHandler {
    private EnvironmentEventHandler() {
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        BetweenlandsWorldStorage storage;
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K && (storage = BetweenlandsWorldStorage.forWorld(event.world)) != null) {
            BLEnvironmentEventRegistry reg = storage.getEnvironmentEventRegistry();
            for (IEnvironmentEvent eevent : reg.getEvents().values()) {
                IGenericDataManagerAccess dataManager;
                if (!eevent.isLoaded()) continue;
                if (reg.isDisabled()) {
                    if (eevent.isActive()) {
                        eevent.setActive(false);
                        eevent.setDefaults();
                    }
                } else {
                    eevent.update(event.world);
                }
                if ((dataManager = eevent.getDataManager()) == null) continue;
                dataManager.func_73660_a();
                if (!dataManager.isDirty()) continue;
                TheBetweenlands.networkWrapper.sendToDimension((IMessage)new MessageSyncEnvironmentEventData(eevent, false), event.world.field_73011_w.getDimension());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        BetweenlandsWorldStorage storage;
        WorldClient world;
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T() && (world = Minecraft.func_71410_x().field_71441_e) != null && world.field_72995_K && (storage = BetweenlandsWorldStorage.forWorld((World)world)) != null) {
            BLEnvironmentEventRegistry reg = storage.getEnvironmentEventRegistry();
            for (IEnvironmentEvent eevent : reg.getEvents().values()) {
                if (!eevent.isLoaded()) continue;
                eevent.update((World)world);
            }
        }
    }

    @SubscribeEvent
    public static void joinWorld(EntityJoinWorldEvent event) {
        BetweenlandsWorldStorage storage;
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP && (storage = BetweenlandsWorldStorage.forWorld(event.getWorld())) != null) {
            for (IEnvironmentEvent eevent : storage.getEnvironmentEventRegistry().getEvents().values()) {
                if (eevent instanceof BLEnvironmentEvent) {
                    TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSyncEnvironmentEventData((BLEnvironmentEvent)eevent, true), (EntityPlayerMP)event.getEntity());
                }
                if (!eevent.isActive()) continue;
                AdvancementCriterionRegistry.EVENT.trigger((EntityPlayerMP)event.getEntity(), eevent.getEventName());
            }
        }
    }
}

