/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.AnimationMathHelper;

public class EntitySwampHag
extends EntityMob
implements IEntityBL {
    private static final DataParameter<Byte> TALK_SOUND = EntityDataManager.func_187226_a(EntitySwampHag.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> SHOULD_JAW_MOVE = EntityDataManager.func_187226_a(EntitySwampHag.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LIVING_SOUND_TIMER = EntityDataManager.func_187226_a(EntitySwampHag.class, (DataSerializer)DataSerializers.field_187192_b);
    public float jawFloat;
    public float breatheFloat;
    AnimationMathHelper animationTalk = new AnimationMathHelper();
    AnimationMathHelper animationBreathe = new AnimationMathHelper();
    private int animationTick;
    private int pathingCooldown = 0;

    public EntitySwampHag(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_184651_r() {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TALK_SOUND, (Object)0);
        this.field_70180_af.func_187214_a(SHOULD_JAW_MOVE, (Object)false);
        this.field_70180_af.func_187214_a(LIVING_SOUND_TIMER, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    protected SoundEvent func_184639_G() {
        int randomSound = this.field_70146_Z.nextInt(4) + 1;
        this.setTalkSound((byte)randomSound);
        switch (this.getTalkSound()) {
            case 1: {
                return SoundRegistry.SWAMP_HAG_LIVING_1;
            }
            case 2: {
                return SoundRegistry.SWAMP_HAG_LIVING_2;
            }
            case 3: {
                return SoundRegistry.SWAMP_HAG_LIVING_3;
            }
        }
        return SoundRegistry.SWAMP_HAG_LIVING_4;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        this.setTalkSound(4);
        this.setShouldJawMove(true);
        return SoundRegistry.SWAMP_HAG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        this.setTalkSound(4);
        this.setShouldJawMove(true);
        return SoundRegistry.SWAMP_HAG_DEATH;
    }

    public void func_70636_d() {
        this.breatheFloat = this.animationBreathe.swing(0.2f, 0.5f, false);
        if (this.func_70638_az() != null && !this.func_184180_b(EntityWight.class).isEmpty()) {
            if (this.pathingCooldown <= 0) {
                if (!this.field_70699_by.func_75497_a((Entity)this.func_70638_az(), 1.0)) {
                    this.pathingCooldown = 20;
                }
            } else {
                --this.pathingCooldown;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateLivingSoundTime();
        }
        if (this.animationTick > 0) {
            --this.animationTick;
        }
        if (this.animationTick == 0) {
            this.setShouldJawMove(false);
            this.jawFloat = this.animationTalk.swing(0.0f, 0.0f, true);
        }
        if (this.getLivingSoundTime() == -this.func_70627_aG()) {
            this.setShouldJawMove(true);
        }
        if (!this.shouldJawMove()) {
            this.jawFloat = this.animationTalk.swing(0.0f, 0.0f, true);
        } else if (this.shouldJawMove() && this.getTalkSound() != 3 && this.getTalkSound() != 4) {
            this.jawFloat = this.animationTalk.swing(2.0f, 0.1f, false);
        } else if (this.shouldJawMove() && this.getTalkSound() == 3 || this.shouldJawMove() && this.getTalkSound() == 4) {
            this.jawFloat = this.animationTalk.swing(0.4f, 1.2f, false);
        }
        super.func_70636_d();
    }

    private byte getTalkSound() {
        return (Byte)this.field_70180_af.func_187225_a(TALK_SOUND);
    }

    private void setTalkSound(int soundIndex) {
        this.field_70180_af.func_187227_b(TALK_SOUND, (Object)((byte)soundIndex));
    }

    public void setShouldJawMove(boolean jawState) {
        this.field_70180_af.func_187227_b(SHOULD_JAW_MOVE, (Object)jawState);
        if (jawState) {
            this.animationTick = 20;
        }
    }

    public boolean shouldJawMove() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_JAW_MOVE);
    }

    private void updateLivingSoundTime() {
        this.field_70180_af.func_187227_b(LIVING_SOUND_TIMER, (Object)this.field_70757_a);
    }

    private int getLivingSoundTime() {
        return (Integer)this.field_70180_af.func_187225_a(LIVING_SOUND_TIMER);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SWAMP_HAG;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

