/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.BossType;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.api.entity.IEntityWithLootModifier;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleRootSpike;
import thebetweenlands.common.entity.EntityRootGrabber;
import thebetweenlands.common.entity.EntitySpikeWave;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFace;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceSmall;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.SpiritTreeKillToken;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;
import thebetweenlands.util.BlockShapeUtils;

public class EntitySpiritTreeFaceLarge
extends EntitySpiritTreeFace
implements IEntityWithLootModifier,
IBLBoss {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public static final byte EVENT_BLOW_ATTACK = 40;
    protected static final UUID STRENGTH_MULTIPLIER_ATTRIBUTE_UUID = UUID.fromString("8a8dccae-273d-445d-b581-81d4a8a979a5");
    protected static final UUID HEALTH_MULTIPLIER_ATTRIBUTE_UUID = UUID.fromString("e29b66a3-2ed2-4598-a44c-ed82a8f03eb2");
    private static final DataParameter<Integer> BLOW_STATE = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPIT_STATE = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROTATING_WAVE_STATE = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CRAWLING_WAVE_STATE = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> WISP_STRENGTH_MODIFIER = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<BlockPos> LAST_LOCKED_WISP = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntitySpiritTreeFaceLarge.class, (DataSerializer)DataSerializers.field_187203_m);
    private int blowTicks = 0;
    private float rotatingWaveStart = 0.0f;
    private int rotatingWaveTicks = 0;
    protected static final int CRAWLING_WAVE_RANGE = 36;
    private float crawlingWaveAngle = 0.0f;
    private int crawlingWaveTicks = 0;
    protected static final int DEFAULT_XP_DROPPED = 300;
    protected static final int DEFAULT_SPIT_DELAY = 10;
    protected static final int DEFAULT_BLOW_DELAY = 30;
    protected static final int DEFAULT_ROTATING_WAVE_DELAY = 40;
    protected static final int DEFAULT_CRAWLING_WAVE_DELAY = 40;
    protected int spitDelay = 10;
    protected int blowDelay = 30;
    protected int rotatingWaveDelay = 40;
    protected int crawlingWaveDelay = 40;

    public EntitySpiritTreeFaceLarge(World world) {
        super(world);
        this.func_70105_a(1.8f, 1.8f);
        this.field_70728_aV = 300;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved(this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntitySpiritTreeFace.AITrackTarget(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntitySpiritTreeFace.AIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntitySpiritTreeFace.AISpit(this, 4.5f){

            @Override
            protected float getSpitDamage() {
                return (float)EntitySpiritTreeFaceLarge.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 3.0f;
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIBlowAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRotatingWaveAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AICrawlingWaveAttack(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIGrabAttack(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIRespawnSmallFaces(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BLOW_STATE, (Object)0);
        this.field_70180_af.func_187214_a(SPIT_STATE, (Object)0);
        this.field_70180_af.func_187214_a(ROTATING_WAVE_STATE, (Object)0);
        this.field_70180_af.func_187214_a(CRAWLING_WAVE_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WISP_STRENGTH_MODIFIER, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LAST_LOCKED_WISP, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BOSSINFO_ID, (Object)Optional.absent());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(600.0);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SPIRIT_TREE_FACE_LARGE;
    }

    @Override
    @Nullable
    public Map<String, Float> getLootModifiers(@Nullable LootContext context, boolean isEntityProperty) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"strength", this.field_70180_af.func_187225_a(WISP_STRENGTH_MODIFIER));
        return builder.build();
    }

    @Override
    public List<BlockPos> findNearbyWoodBlocks() {
        List<LocationSpiritTree> locations = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this));
        if (!locations.isEmpty()) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            positions.addAll(locations.get(0).getLargeFacePositions());
            if (!positions.isEmpty()) {
                return positions;
            }
        }
        return super.findNearbyWoodBlocks();
    }

    protected List<BlockPos> findSmallFacesBlocks() {
        List<BlockPos> positions;
        List<LocationSpiritTree> locations = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this));
        if (!locations.isEmpty() && !(positions = locations.get(0).getSmallFacePositions()).isEmpty()) {
            return positions;
        }
        return super.findNearbyWoodBlocks();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SPIRIT_TREE_FACE_LARGE_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SPIRIT_TREE_FACE_LARGE_LIVING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        block4: {
            Vec3d vec;
            float rz;
            float ry;
            float rx;
            Random rnd;
            int i;
            block3: {
                super.func_70103_a(id);
                if (id != 2) break block3;
                Vec3d frontCenter = this.getFrontCenter();
                for (int i2 = 0; i2 < 16; ++i2) {
                    float rx2 = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                    float ry2 = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                    float rz2 = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                    Vec3d vec2 = new Vec3d((double)rx2, (double)ry2, (double)rz2);
                    vec2 = vec2.func_72432_b();
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, frontCenter.field_72450_a + (double)rx2, frontCenter.field_72448_b + (double)ry2, frontCenter.field_72449_c + (double)rz2, vec2.field_72450_a * 1.5, vec2.field_72448_b * 1.5, vec2.field_72449_c * 1.5, new int[]{Block.func_149682_b((Block)BlockRegistry.LOG_SPIRIT_TREE)});
                }
                break block4;
            }
            if (id != 40) break block4;
            Vec3d frontCenter = this.getFrontCenter();
            for (i = 0; i < 64; ++i) {
                rnd = this.field_70170_p.field_73012_v;
                rx = rnd.nextFloat() * 6.0f - 3.0f + (float)(this.getFacing().func_82601_c() * 2);
                ry = rnd.nextFloat() * 6.0f - 3.0f + (float)(this.getFacing().func_96559_d() * 2);
                rz = rnd.nextFloat() * 6.0f - 3.0f + (float)(this.getFacing().func_82599_e() * 2);
                vec = new Vec3d((double)rx, (double)ry, (double)rz);
                vec = vec.func_72432_b();
                ParticleRootSpike particle = (ParticleRootSpike)BLParticles.ROOT_SPIKE.spawn(this.field_70170_p, frontCenter.field_72450_a, frontCenter.field_72448_b - 0.25, frontCenter.field_72449_c, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * (double)0.45f, vec.field_72448_b * (double)0.45f + (double)0.2f, vec.field_72449_c * (double)0.45f));
                particle.setUseSound(this.field_70146_Z.nextInt(15) == 0);
            }
            frontCenter = this.getFrontCenter();
            for (i = 0; i < 32; ++i) {
                rnd = this.field_70170_p.field_73012_v;
                rx = rnd.nextFloat() - 0.5f + (float)this.getFacing().func_82601_c() * 0.5f;
                ry = rnd.nextFloat() - 0.5f + (float)this.getFacing().func_96559_d() * 0.5f;
                rz = rnd.nextFloat() - 0.5f + (float)this.getFacing().func_82599_e() * 0.5f;
                vec = new Vec3d((double)rx, (double)ry, (double)rz);
                vec = vec.func_72432_b();
                BLParticles.MOTION_ITEM_BREAKING.spawn(this.field_70170_p, frontCenter.field_72450_a, frontCenter.field_72448_b - 0.25, frontCenter.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * 0.25, vec.field_72448_b * 0.25, vec.field_72449_c * 0.25)).withData(ItemRegistry.SAP_SPIT, 0));
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getWispStrengthModifier() > 1.0f) {
            amount /= 1.0f + (this.getWispStrengthModifier() - 1.0f) * 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            List<SpiritTreeKillToken> killTokens = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getSpiritTreeKillTokens();
            if (killTokens.size() > 32) {
                killTokens.remove(0);
            }
            killTokens.add(new SpiritTreeKillToken(this.func_180425_c(), this.getWispStrengthModifier()));
            List<LocationSpiritTree> locations = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this));
            if (!locations.isEmpty()) {
                LocationSpiritTree location = locations.get(0);
                List smallFaces = this.field_70170_p.func_72872_a(EntitySpiritTreeFaceSmall.class, location.getEnclosingBounds());
                for (Object face : smallFaces) {
                    face.func_184174_b(false);
                    face.func_70106_y();
                }
                ArrayList<BlockPos> wispPositions = new ArrayList<BlockPos>();
                wispPositions.addAll(location.getGeneratedWispPositions());
                wispPositions.addAll(location.getNotGeneratedWispPositions());
                for (BlockPos wisp : wispPositions) {
                    if (this.field_70170_p.func_180495_p(wisp).func_177230_c() != BlockRegistry.WISP) continue;
                    this.field_70170_p.func_175698_g(wisp);
                }
                List<BlockPos> positions = location.getLargeFacePositions();
                BlockPos lowest = null;
                for (BlockPos pos : positions) {
                    if (lowest != null && lowest.func_177956_o() <= pos.func_177956_o()) continue;
                    lowest = pos;
                }
                if (lowest != null) {
                    int radius = 5;
                    for (int xo = -radius; xo <= radius; ++xo) {
                        for (int yo = -radius; yo <= radius; ++yo) {
                            for (int zo = -radius; zo <= radius; ++zo) {
                                if (xo * xo + yo * yo + zo * zo > radius * radius) continue;
                                BlockPos pos = lowest.func_177982_a(xo, yo, zo);
                                IBlockState state = this.field_70170_p.func_180495_p(pos);
                                if (SurfaceType.GRASS_AND_DIRT.matches(state) && !this.field_70170_p.func_180495_p(pos.func_177984_a()).func_185915_l() && this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                                    this.field_70170_p.func_175656_a(pos, BlockRegistry.SPREADING_SLUDGY_DIRT.func_176223_P());
                                }
                                if (state.func_177230_c() != BlockRegistry.LOG_SPIRIT_TREE || this.field_70170_p.field_73012_v.nextInt(5) != 0) continue;
                                this.field_70170_p.func_175656_a(pos, BlockRegistry.LOG_SPREADING_ROTTEN_BARK.func_176223_P());
                            }
                        }
                    }
                }
                for (BlockPos pos : location.getSmallFacePositions()) {
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() != BlockRegistry.LOG_SPIRIT_TREE || this.field_70170_p.field_73012_v.nextInt(10) != 0) continue;
                    this.field_70170_p.func_175656_a(pos, BlockRegistry.LOG_SPREADING_ROTTEN_BARK.func_176223_P());
                }
                location.getGuard().clear(this.field_70170_p);
                location.setVisible(false);
                location.setDirty(true);
            }
        }
    }

    @Override
    public boolean isAttacking() {
        return super.isAttacking() || this.blowTicks > 0;
    }

    @Override
    protected void playSpitSound() {
        this.func_184185_a(SoundRegistry.SPIRIT_TREE_FACE_LARGE_SPIT, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
    }

    @Override
    protected void playEmergeSound() {
        this.func_184185_a(SoundRegistry.SPIRIT_TREE_FACE_LARGE_EMERGE, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (LAST_LOCKED_WISP.equals(key) && this.field_70170_p.field_72995_K) {
            this.wispLockEffect((BlockPos)this.field_70180_af.func_187225_a(LAST_LOCKED_WISP));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void wispLockEffect(BlockPos pos) {
        for (int i = 0; i < 64; ++i) {
            Vec3d dir = new Vec3d((double)(this.field_70146_Z.nextFloat() - 0.5f), (double)(this.field_70146_Z.nextFloat() - 0.5f + 0.25f), (double)(this.field_70146_Z.nextFloat() - 0.5f));
            dir = dir.func_72432_b().func_186678_a(2.0);
            BLParticles.CORRUPTED.spawn(this.field_70170_p, (double)pos.func_177958_n() + 0.5 + (double)(this.field_70146_Z.nextFloat() / 2.0f) - 0.25, (double)pos.func_177956_o() + 0.5 + (double)(this.field_70146_Z.nextFloat() / 2.0f) - 0.25, (double)pos.func_177952_p() + 0.5 + (double)(this.field_70146_Z.nextFloat() / 2.0f) - 0.25, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c));
        }
        this.field_70170_p.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.DAMAGE_REDUCTION, SoundCategory.HOSTILE, 0.65f, 0.5f, false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BOSSINFO_ID, (Object)Optional.of((Object)this.bossInfo.func_186737_d()));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        this.bossInfo.func_186735_a(0.0f);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAnchored()) {
            this.func_70105_a(1.8f, 1.8f);
        } else {
            this.func_70105_a(1.8f, 0.2f);
        }
        if ((Integer)this.field_70180_af.func_187225_a(BLOW_STATE) != 0 || (Integer)this.field_70180_af.func_187225_a(ROTATING_WAVE_STATE) != 0 || (Integer)this.field_70180_af.func_187225_a(CRAWLING_WAVE_STATE) != 0 || (Integer)this.field_70180_af.func_187225_a(SPIT_STATE) != 0) {
            this.setGlowTicks(20);
        }
        if (!this.field_70170_p.field_72995_K) {
            float strengthModifier;
            if (this.isActive() && this.func_70089_S() && this.func_70638_az() != null) {
                List<LocationSpiritTree> locations;
                if (this.field_70173_aa % 20 == 0) {
                    this.updateWispStrengthModifier();
                }
                if (this.field_70173_aa % 10 == 0 && !(locations = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this))).isEmpty()) {
                    LocationSpiritTree location = locations.get(0);
                    ArrayList<BlockPos> wispPositions = new ArrayList<BlockPos>();
                    wispPositions.addAll(location.getNotGeneratedWispPositions());
                    if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                        wispPositions.addAll(location.getGeneratedWispPositions());
                    }
                    for (BlockPos wispPosition : wispPositions) {
                        if (location.getGuard().isGuarded(this.field_70170_p, null, wispPosition) || this.field_70170_p.func_180495_p(wispPosition).func_177230_c() != BlockRegistry.WISP) continue;
                        location.getGuard().setGuarded(this.field_70170_p, wispPosition, true);
                        this.field_70180_af.func_187227_b(LAST_LOCKED_WISP, (Object)wispPosition);
                        break;
                    }
                }
            }
            this.field_70728_aV = (strengthModifier = this.getWispStrengthModifier()) <= 1.0f ? (int)(300.0f * strengthModifier) : (int)(300.0f * (1.0f + (strengthModifier - 1.0f) * 6.0f));
            IAttributeInstance attackAttribute = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
            attackAttribute.func_188479_b(STRENGTH_MULTIPLIER_ATTRIBUTE_UUID);
            attackAttribute.func_111121_a(new AttributeModifier(STRENGTH_MULTIPLIER_ATTRIBUTE_UUID, "Wisp strength modifier", (double)(strengthModifier - 1.0f), 2));
            if (this.blowTicks > 0) {
                if (this.blowTicks > 20 + this.blowDelay) {
                    this.field_70180_af.func_187227_b(BLOW_STATE, (Object)3);
                    if ((this.blowTicks - (21 + this.blowDelay)) % 15 == 0) {
                        this.doBlowAttack();
                        this.field_70170_p.func_72960_a((Entity)this, (byte)40);
                        this.func_184185_a(SoundRegistry.SPIRIT_TREE_FACE_SPIT_ROOT_SPIKES, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                    }
                } else if (this.blowTicks > this.blowDelay) {
                    this.field_70180_af.func_187227_b(BLOW_STATE, (Object)2);
                    if (this.blowTicks == this.blowDelay + 1) {
                        this.func_184185_a(SoundRegistry.SPIRIT_TREE_FACE_SUCK, 1.0f, 1.0f);
                    }
                } else {
                    this.field_70180_af.func_187227_b(BLOW_STATE, (Object)1);
                }
                if (this.blowTicks > 160 + this.blowDelay) {
                    this.field_70180_af.func_187227_b(BLOW_STATE, (Object)0);
                    this.blowTicks = 0;
                } else {
                    ++this.blowTicks;
                }
            }
            if (this.rotatingWaveTicks > 0) {
                if (this.rotatingWaveTicks > this.rotatingWaveDelay) {
                    this.field_70180_af.func_187227_b(ROTATING_WAVE_STATE, (Object)2);
                    if ((this.rotatingWaveTicks - 1 - this.rotatingWaveDelay) % 3 == 0) {
                        for (int i = 0; i < 2; ++i) {
                            double increment = 0.3141592653589793;
                            double a1 = ((double)this.rotatingWaveStart + (double)((this.rotatingWaveTicks - this.rotatingWaveDelay) / 3) * increment) * (double)(i == 0 ? 1 : -1);
                            double a2 = ((double)this.rotatingWaveStart + (double)((this.rotatingWaveTicks - this.rotatingWaveDelay) / 3 + 1) * increment) * (double)(i == 0 ? 1 : -1);
                            double start = Math.min(a1, a2);
                            double end = Math.max(a1, a2);
                            List<BlockPos> blocks = BlockShapeUtils.getRingSegment(this.getAnchor(), start, end, 6.5, 14.5, false, new ArrayList<BlockPos>());
                            ArrayList<BlockPos> spawnBlocks = new ArrayList<BlockPos>();
                            for (BlockPos pos : blocks) {
                                BlockPos spawnPos = this.getWaveGroundPos(pos, 0);
                                if (spawnPos == null) continue;
                                spawnBlocks.add(spawnPos);
                            }
                            if (spawnBlocks.isEmpty()) continue;
                            EntitySpikeWave spikeWave = new EntitySpikeWave(this.field_70170_p);
                            spikeWave.delay = 2;
                            spikeWave.setAttackDamage(10.0f * this.getWispStrengthModifier());
                            for (BlockPos pos : spawnBlocks) {
                                spikeWave.addPosition(pos);
                            }
                            this.field_70170_p.func_72838_d((Entity)spikeWave);
                        }
                    }
                } else {
                    this.field_70180_af.func_187227_b(ROTATING_WAVE_STATE, (Object)1);
                }
                if (this.rotatingWaveTicks >= 180 + this.rotatingWaveDelay) {
                    this.rotatingWaveTicks = 0;
                    this.field_70180_af.func_187227_b(ROTATING_WAVE_STATE, (Object)0);
                } else {
                    ++this.rotatingWaveTicks;
                }
            }
            if (this.crawlingWaveTicks > 0) {
                int ticksPerWave = 48;
                if (this.crawlingWaveTicks > this.crawlingWaveDelay) {
                    this.field_70180_af.func_187227_b(CRAWLING_WAVE_STATE, (Object)2);
                    if (this.func_70638_az() != null) {
                        if ((this.crawlingWaveTicks - 1 - this.crawlingWaveDelay) % 48 == 0) {
                            this.crawlingWaveAngle = (float)Math.atan2(this.func_70638_az().field_70161_v - this.field_70161_v, this.func_70638_az().field_70165_t - this.field_70165_t);
                        }
                        if ((this.crawlingWaveTicks - 1 - this.crawlingWaveDelay) % 4 == 0) {
                            int dist = 14 + (this.crawlingWaveTicks - 1 - this.crawlingWaveDelay) / 4 * 3 % 36;
                            double a1 = (double)this.crawlingWaveAngle - 0.19634954084936207;
                            double a2 = (double)this.crawlingWaveAngle + 0.19634954084936207;
                            List<BlockPos> blocks = BlockShapeUtils.getRingSegment(this.getAnchor(), a1, a2, dist, dist + 3, false, new ArrayList<BlockPos>());
                            ArrayList<BlockPos> spawnBlocks = new ArrayList<BlockPos>();
                            for (BlockPos pos : blocks) {
                                BlockPos spawnPos = this.getWaveGroundPos(pos, 4);
                                if (spawnPos == null) continue;
                                spawnBlocks.add(spawnPos);
                            }
                            if (!spawnBlocks.isEmpty()) {
                                EntitySpikeWave spikeWave = new EntitySpikeWave(this.field_70170_p);
                                spikeWave.delay = 2;
                                spikeWave.setAttackDamage(10.0f * this.getWispStrengthModifier());
                                for (BlockPos pos : spawnBlocks) {
                                    spikeWave.addPosition(pos);
                                }
                                this.field_70170_p.func_72838_d((Entity)spikeWave);
                            }
                        }
                    }
                } else {
                    this.field_70180_af.func_187227_b(CRAWLING_WAVE_STATE, (Object)1);
                }
                if (this.crawlingWaveTicks >= 144 + this.crawlingWaveDelay) {
                    this.crawlingWaveTicks = 0;
                    this.field_70180_af.func_187227_b(CRAWLING_WAVE_STATE, (Object)0);
                } else {
                    ++this.crawlingWaveTicks;
                }
            }
        } else {
            int blowState = (Integer)this.field_70180_af.func_187225_a(BLOW_STATE);
            if (blowState == 2) {
                Vec3d frontCenter = this.getFrontCenter();
                for (int i = 0; i < 4; ++i) {
                    Random rnd = this.field_70170_p.field_73012_v;
                    float rx = rnd.nextFloat() * 4.0f - 2.0f + (float)(this.getFacing().func_82601_c() * 4);
                    float ry = rnd.nextFloat() * 4.0f - 2.0f + (float)(this.getFacing().func_96559_d() * 4);
                    float rz = rnd.nextFloat() * 4.0f - 2.0f + (float)(this.getFacing().func_82599_e() * 4);
                    Vec3d vec = new Vec3d((double)rx, (double)ry, (double)rz);
                    vec = vec.func_72432_b();
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, frontCenter.field_72450_a + (double)rx, frontCenter.field_72448_b - 0.75 + (double)ry, frontCenter.field_72449_c + (double)rz, -vec.field_72450_a * 0.5, -vec.field_72448_b * 0.5, -vec.field_72449_c * 0.5, new int[0]);
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("wispStrengthModifier", ((Float)this.field_70180_af.func_187225_a(WISP_STRENGTH_MODIFIER)).floatValue());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(WISP_STRENGTH_MODIFIER, (Object)Float.valueOf(nbt.func_74760_g("wispStrengthModifier")));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    @Nullable
    protected BlockPos getWaveGroundPos(BlockPos pos, int yOff) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int yo = 0; yo < 16; ++yo) {
            checkPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - yo + yOff, pos.func_177952_p());
            IBlockState state = this.field_70170_p.func_180495_p((BlockPos)checkPos);
            if (state.func_185890_d((IBlockAccess)this.field_70170_p, (BlockPos)checkPos) == null) continue;
            if (!state.isSideSolid((IBlockAccess)this.field_70170_p, (BlockPos)checkPos, EnumFacing.UP)) break;
            return checkPos.func_185334_h();
        }
        return null;
    }

    public boolean isTargetInBlowRange(EntityLivingBase target) {
        if (target.func_70068_e((Entity)this) <= 25.0) {
            Vec3d center = this.getFrontCenter();
            Vec3d targetCenter = new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
            Vec3d dir = targetCenter.func_178788_d(center).func_72432_b();
            Vec3d facing = new Vec3d((double)this.getFacing().func_82601_c(), (double)this.getFacing().func_96559_d(), (double)this.getFacing().func_82599_e());
            float angle = (float)(Math.acos(facing.func_72430_b(dir)) / 2.0 / Math.PI) * 360.0f;
            return angle >= 0.0f && angle <= 90.0f;
        }
        return false;
    }

    public void doBlowAttack() {
        Vec3d frontCenter = this.getFrontCenter();
        List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(frontCenter.field_72450_a - 5.0, frontCenter.field_72448_b - 5.0, frontCenter.field_72449_c - 5.0, frontCenter.field_72450_a + 5.0, frontCenter.field_72448_b + 5.0, frontCenter.field_72449_c + 5.0));
        for (EntityLivingBase target : targets) {
            if (target == this || !this.isTargetInBlowRange(target)) continue;
            this.func_70652_k((Entity)target);
        }
    }

    public void startBlowAttack() {
        this.blowTicks = 1;
        this.blowDelay = this.getWispStrengthModifier() > 1.0f ? (int)(30.0f / (1.0f + (this.getWispStrengthModifier() - 1.0f) * 2.0f)) : 30;
    }

    public boolean isTargetInRotatingWaveAttackRange(EntityLivingBase target) {
        double dx = this.field_70165_t - target.field_70165_t;
        double dz = this.field_70161_v - target.field_70161_v;
        double dstSq = dx * dx + dz * dz;
        int innerSq = 36;
        int outerSq = 196;
        return dstSq >= (double)innerSq && dstSq <= (double)outerSq;
    }

    public void startRotatingWaveAttack() {
        this.rotatingWaveTicks = 1;
        this.rotatingWaveStart = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
        this.rotatingWaveDelay = this.getWispStrengthModifier() > 1.0f ? (int)(40.0f / (1.0f + (this.getWispStrengthModifier() - 1.0f) * 2.0f)) : 40;
        this.field_70180_af.func_187227_b(ROTATING_WAVE_STATE, (Object)1);
    }

    public boolean isTargetInCrawlingWaveAttackRange(EntityLivingBase target) {
        double dx = this.field_70165_t - target.field_70165_t;
        double dz = this.field_70161_v - target.field_70161_v;
        double dstSq = dx * dx + dz * dz;
        int innerSq = 196;
        int outerSq = 2500;
        return dstSq >= (double)innerSq && dstSq <= (double)outerSq;
    }

    public void startCrawlingWaveAttack() {
        this.crawlingWaveTicks = 1;
        this.crawlingWaveDelay = this.getWispStrengthModifier() > 1.0f ? (int)(40.0f / (1.0f + (this.getWispStrengthModifier() - 1.0f) * 2.0f)) : 40;
        this.field_70180_af.func_187227_b(CRAWLING_WAVE_STATE, (Object)1);
    }

    public boolean isTargetInGrabAttackRange(EntityLivingBase target) {
        double dx = this.field_70165_t - target.field_70165_t;
        double dz = this.field_70161_v - target.field_70161_v;
        double dstSq = dx * dx + dz * dz;
        int outerSq = 2500;
        return dstSq <= (double)outerSq;
    }

    public boolean startGrabAttack() {
        if (this.func_70638_az() != null) {
            EntityLivingBase target = this.func_70638_az();
            for (int i = 0; i < 6; ++i) {
                BlockPos pos = new BlockPos(target.field_70165_t + (double)this.field_70146_Z.nextInt(3) - 1.0, target.field_70163_u - 1.0, target.field_70161_v + (double)this.field_70146_Z.nextInt(3) - 1.0);
                if (!this.field_70170_p.func_175623_d(pos.func_177984_a()) || !this.field_70170_p.func_175623_d(pos.func_177981_b(2))) continue;
                boolean validPos = true;
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        if (this.field_70170_p.func_175677_d(pos.func_177982_a(xo, 0, zo), false)) continue;
                        validPos = false;
                    }
                }
                if (!validPos) continue;
                EntityRootGrabber grabber = new EntityRootGrabber(this.field_70170_p);
                grabber.setPosition(pos, (int)(40.0f / this.getWispStrengthModifier()));
                this.field_70170_p.func_72838_d((Entity)grabber);
                return true;
            }
        }
        return false;
    }

    @Override
    public void startSpit(float spitDamage) {
        super.startSpit(spitDamage);
        this.spitDelay = this.getWispStrengthModifier() > 1.0f ? (int)(10.0f / (1.0f + (this.getWispStrengthModifier() - 1.0f) * 2.0f)) : 10;
        this.field_70180_af.func_187227_b(SPIT_STATE, (Object)1);
    }

    @Override
    protected void updateSpitAttack() {
        if (this.spitTicks == this.spitDelay) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
            this.setGlowTicks(10);
            this.playSpitSound();
        }
        if (this.spitTicks > 6 + this.spitDelay) {
            this.doSpitAttack();
            this.field_70180_af.func_187227_b(SPIT_STATE, (Object)0);
            this.spitTicks = 0;
        } else {
            ++this.spitTicks;
        }
    }

    protected void updateWispStrengthModifier() {
        List<LocationSpiritTree> locations = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this));
        if (!locations.isEmpty()) {
            int generatedWisps;
            LocationSpiritTree location = locations.get(0);
            int activeWisps = location.getActiveWisps();
            float newModifier = activeWisps < (generatedWisps = location.getGeneratedWispPositions().size()) ? 0.5f + (float)activeWisps / (float)generatedWisps * 0.5f : Math.min(1.0f + (float)(activeWisps - generatedWisps) / 6.0f, 2.0f);
            float decay = (float)Math.pow(this.func_110143_aJ() / this.func_110138_aP(), 6.0) * 0.33f;
            this.field_70180_af.func_187227_b(WISP_STRENGTH_MODIFIER, (Object)Float.valueOf(decay * newModifier + (1.0f - decay) * ((Float)this.field_70180_af.func_187225_a(WISP_STRENGTH_MODIFIER)).floatValue()));
        }
    }

    public float getWispStrengthModifier() {
        return ((Float)this.field_70180_af.func_187225_a(WISP_STRENGTH_MODIFIER)).floatValue();
    }

    @Override
    public UUID getBossInfoUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(BOSSINFO_ID)).or((Object)new UUID(0L, 0L));
    }

    @Override
    public BossType getBossType() {
        return BossType.MINI_BOSS;
    }

    @Override
    public Vec3d getMiniBossTagOffset(float partialTicks) {
        return new Vec3d((double)((float)this.getFacing().func_82601_c() * (this.field_70130_N / 2.0f)), (double)this.field_70131_O + 0.5, (double)((float)this.getFacing().func_82599_e() * (this.field_70130_N / 2.0f)));
    }

    public static class AIGrabAttack
    extends EntityAIBase {
        protected final EntitySpiritTreeFaceLarge entity;
        protected int cooldown = 30;

        public AIGrabAttack(EntitySpiritTreeFaceLarge entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            if (this.entity.isActive() && !this.entity.isAttacking() && this.entity.func_70638_az() != null && this.entity.func_70638_az().field_70122_E && this.entity.isTargetInGrabAttackRange(this.entity.func_70638_az())) {
                if (this.cooldown <= 0) {
                    this.cooldown = (int)((float)(60 + this.entity.field_70146_Z.nextInt(80)) / this.entity.getWispStrengthModifier());
                    return true;
                }
                --this.cooldown;
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.startGrabAttack();
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public static class AICrawlingWaveAttack
    extends EntityAIBase {
        protected final EntitySpiritTreeFaceLarge entity;
        protected int cooldown = 30;

        public AICrawlingWaveAttack(EntitySpiritTreeFaceLarge entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            if (this.entity.isActive() && this.entity.crawlingWaveTicks == 0 && this.entity.func_70638_az() != null && this.entity.isTargetInCrawlingWaveAttackRange(this.entity.func_70638_az())) {
                if (this.cooldown <= 0) {
                    this.cooldown = (int)((float)(60 + this.entity.field_70146_Z.nextInt(80)) / this.entity.getWispStrengthModifier());
                    return true;
                }
                --this.cooldown;
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.startCrawlingWaveAttack();
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public static class AIRotatingWaveAttack
    extends EntityAIBase {
        protected final EntitySpiritTreeFaceLarge entity;
        protected int cooldown = 30;

        public AIRotatingWaveAttack(EntitySpiritTreeFaceLarge entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            if (this.entity.isActive() && this.entity.rotatingWaveTicks == 0 && this.entity.func_70638_az() != null && this.entity.isTargetInRotatingWaveAttackRange(this.entity.func_70638_az())) {
                if (this.cooldown <= 0) {
                    this.cooldown = (int)((float)(60 + this.entity.field_70146_Z.nextInt(80)) / this.entity.getWispStrengthModifier());
                    return true;
                }
                --this.cooldown;
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.startRotatingWaveAttack();
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public static class AIBlowAttack
    extends EntityAIBase {
        protected final EntitySpiritTreeFaceLarge entity;
        protected int cooldown = 30;

        public AIBlowAttack(EntitySpiritTreeFaceLarge entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            if (this.entity.isActive() && !this.entity.isAttacking() && this.entity.func_70638_az() != null && this.entity.isTargetInBlowRange(this.entity.func_70638_az())) {
                if (this.cooldown <= 0) {
                    this.cooldown = (int)((float)(30 + this.entity.field_70146_Z.nextInt(30)) / this.entity.getWispStrengthModifier());
                    return true;
                }
                --this.cooldown;
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.startBlowAttack();
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public static class AIRespawnSmallFaces
    extends EntityAIBase {
        protected final EntitySpiritTreeFaceLarge entity;
        protected int executeCheckCooldown = 0;
        protected boolean shouldContinue = true;
        protected int spawnCooldown = 0;

        public AIRespawnSmallFaces(EntitySpiritTreeFaceLarge entity) {
            this.entity = entity;
        }

        protected int countSmallFaces() {
            return this.entity.field_70170_p.func_72872_a(EntitySpiritTreeFaceSmall.class, this.entity.func_174813_aQ().func_186662_g(40.0)).size();
        }

        protected boolean hasEnoughSmallFaces() {
            return this.countSmallFaces() >= 8;
        }

        public boolean func_75250_a() {
            if (this.entity.func_70089_S() && this.entity.isActive()) {
                if (this.executeCheckCooldown <= 0) {
                    this.executeCheckCooldown = 20 + this.entity.field_70146_Z.nextInt(20);
                    return !this.hasEnoughSmallFaces();
                }
                --this.executeCheckCooldown;
            }
            return false;
        }

        public void func_75249_e() {
            this.shouldContinue = true;
        }

        public void func_75246_d() {
            if (this.spawnCooldown <= 0) {
                this.spawnCooldown = (int)((float)(180 + this.entity.field_70146_Z.nextInt(100)) / this.entity.getWispStrengthModifier());
                List<BlockPos> blocks = this.entity.findSmallFacesBlocks();
                if (!blocks.isEmpty()) {
                    EntitySpiritTreeFaceSmall face = new EntitySpiritTreeFaceSmall(this.entity.field_70170_p);
                    block0: for (int i = 0; i < 16; ++i) {
                        BlockPos anchor = blocks.get(this.entity.field_70146_Z.nextInt(blocks.size()));
                        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
                        facings.addAll(Arrays.asList(EnumFacing.field_82609_l));
                        Collections.shuffle(facings, this.entity.field_70146_Z);
                        Iterator iterator = facings.iterator();
                        while (iterator.hasNext()) {
                            EnumFacing facing;
                            EnumFacing facingUp = (facing = (EnumFacing)iterator.next()).func_176740_k().func_176720_b() ? EnumFacing.field_176754_o[this.entity.field_70146_Z.nextInt(EnumFacing.field_176754_o.length)] : EnumFacing.UP;
                            if (face.checkAnchorAt(anchor, facing, facingUp, 7) != 0) continue;
                            face.func_180482_a(this.entity.field_70170_p.func_175649_E(anchor), null);
                            face.setPositionToAnchor(anchor, facing, facingUp);
                            this.entity.field_70170_p.func_72838_d((Entity)face);
                            break block0;
                        }
                    }
                    if (this.hasEnoughSmallFaces()) {
                        this.shouldContinue = false;
                    }
                }
            }
            --this.spawnCooldown;
        }

        public boolean func_75253_b() {
            return this.entity.isActive() && this.shouldContinue;
        }
    }
}

