/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.AnimationMathHelper;

public class EntityBlindCaveFish
extends EntityCreature
implements IEntityBL {
    public float moveProgress;
    private AnimationMathHelper animation = new AnimationMathHelper();

    public EntityBlindCaveFish(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.2f);
        this.func_70050_g(80);
        this.field_70765_h = new BlindFishMoveHelper(this);
        this.func_184644_a(PathNodeType.WALKABLE, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4, 80));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    public PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundRegistry.ANGLER_ATTACK;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.ANGLER_DEATH;
    }

    @MethodsReturnNonnullByDefault
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public boolean func_70601_bi() {
        return this.field_70163_u <= 15.0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.moveProgress = this.func_70090_H() ? this.animation.swing(1.2f, 0.4f, false) : this.animation.swing(2.0f, 0.4f, false);
        } else if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.25;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.075f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.075f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70160_al = true;
            if (this.field_70170_p.func_82737_E() % 5L == 0L) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187684_cg, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--air);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(80);
        }
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.BLIND_CAVE_FISH;
    }

    static class BlindFishMoveHelper
    extends EntityMoveHelper {
        private final EntityBlindCaveFish fish;

        public BlindFishMoveHelper(EntityBlindCaveFish fish) {
            super((EntityLiving)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.fish.field_70165_t;
                double d1 = this.field_75647_c - this.fish.field_70163_u;
                double d2 = this.field_75644_d - this.fish.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.fish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.fish.func_70659_e(this.fish.func_70689_ay() + (f1 - this.fish.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.fish.field_70173_aa + this.fish.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.fish.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.fish.field_70177_z * ((float)Math.PI / 180));
                this.fish.field_70159_w += d4 * d5;
                this.fish.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.fish.field_70173_aa + this.fish.func_145782_y()) * 0.75) * 0.05;
                this.fish.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.fish.field_70181_x += (double)this.fish.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.fish.func_70671_ap();
                double d7 = this.fish.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.fish.func_70047_e() + this.fish.field_70163_u + d1 / d3;
                double d9 = this.fish.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.fish.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }
}

