/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai.gecko;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.common.entity.ai.gecko.EntityAIGeckoHide;
import thebetweenlands.common.entity.mobs.EntityGecko;

public class EntityAIAvoidEntityGecko
extends EntityAIGeckoHide {
    public final Predicate<Entity> viableSelector = new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return entity.func_70089_S() && EntityAIAvoidEntityGecko.this.gecko.func_70635_at().func_75522_a(entity);
        }
    };
    private Entity closestLivingEntity;
    private float distance;
    private Class<? extends Entity> avoidingEntityClass;

    public EntityAIAvoidEntityGecko(EntityGecko gecko, Class<? extends Entity> avoidingEntityClass, float distance, double farSpeed, double nearSpeed) {
        super(gecko, nearSpeed, nearSpeed);
        this.distance = distance;
        this.avoidingEntityClass = avoidingEntityClass;
    }

    @Override
    protected boolean shouldFlee() {
        if (this.avoidingEntityClass == EntityPlayer.class) {
            this.closestLivingEntity = this.gecko.field_70170_p.func_184136_b((Entity)this.gecko, (double)this.distance);
            if (this.closestLivingEntity == null) {
                return false;
            }
        } else {
            List list = this.gecko.field_70170_p.func_175647_a(this.avoidingEntityClass, this.gecko.func_174813_aQ().func_72314_b((double)this.distance, 3.0, (double)this.distance), this.viableSelector);
            if (list.isEmpty()) {
                return false;
            }
            this.closestLivingEntity = (Entity)list.get(0);
        }
        return true;
    }

    @Override
    protected Vec3d getFleeingCausePosition() {
        return this.gecko != null ? this.gecko.func_174791_d() : null;
    }
}

