/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.SpikeRenderer;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleRootSpike;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityRootGrabber
extends Entity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityRootGrabber.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> RETRACT = EntityDataManager.func_187226_a(EntityRootGrabber.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final byte EVENT_BROKEN = 40;
    public static final byte EVENT_HIT = 41;
    protected BlockPos origin;
    protected int delay;
    protected int maxAge = 240;
    protected int prevAttackTicks = 0;
    protected int attackTicks = 0;
    protected int prevRetractTicks = 0;
    protected int retractTicks = 0;
    protected boolean emergeSound = true;
    protected boolean retractSound = true;
    @Nullable
    protected EntityLivingBase grabbedEntity = null;
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<RootPart> modelParts;

    public EntityRootGrabber(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.0f);
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(RETRACT, (Object)false);
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        if (damage >= 1.0f && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.field_70170_p.func_72960_a((Entity)this, (byte)40);
        }
    }

    public void setPosition(BlockPos pos, int delay) {
        this.origin = pos;
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.field_70142_S = this.field_70169_q = this.field_70165_t;
        this.field_70137_T = this.field_70167_r = this.field_70163_u;
        this.field_70136_U = this.field_70166_s = this.field_70161_v;
        this.delay = delay;
    }

    @SideOnly(value=Side.CLIENT)
    public void initRootModels() {
        if (this.modelParts == null) {
            this.modelParts = new ArrayList<RootPart>();
            int rings = 2 + this.field_70170_p.field_73012_v.nextInt(2);
            for (int j = 0; j < rings; ++j) {
                float radius = (this.field_70130_N - 0.5f) / (float)rings * (float)j;
                int roots = 5 + this.field_70170_p.field_73012_v.nextInt(5);
                for (int i = 0; i < roots; ++i) {
                    float scale = 0.6f + this.field_70146_Z.nextFloat() * 0.2f;
                    double angle = (double)i * Math.PI * 2.0 / (double)roots;
                    Vec3d offset = new Vec3d(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
                    SpikeRenderer renderer = new SpikeRenderer(3, scale * 0.5f, scale, 1.0f, this.field_70146_Z.nextLong(), -scale * 0.5f * 1.5f, 0.0, -scale * 0.5f * 1.5f).build(DefaultVertexFormats.field_181703_c, Minecraft.func_71410_x().func_147117_R().func_110572_b(ParticleRootSpike.SPRITE.toString()));
                    RootPart part = new RootPart();
                    part.renderer = renderer;
                    part.x = (float)offset.field_72450_a;
                    part.y = (float)offset.field_72448_b;
                    part.z = (float)offset.field_72449_c;
                    part.yaw = -((float)Math.toDegrees(angle));
                    part.pitch = 30.0f;
                    this.modelParts.add(part);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())));
            return this.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    public float getRootYOffset(float partialTicks) {
        float attackTicks = (float)this.prevAttackTicks + (float)(this.attackTicks - this.prevAttackTicks) * partialTicks;
        float retractTicks = (float)this.prevRetractTicks + (float)(this.retractTicks - this.prevRetractTicks) * partialTicks;
        float y = attackTicks < 5.0f ? -2.5f + attackTicks / 5.0f : (attackTicks >= (float)this.delay ? -1.5f + Math.min(1.25f, (attackTicks - (float)this.delay) / 0.5f) : -1.5f);
        y = Math.max(-2.5f, y - retractTicks / 5.0f * 2.5f);
        return y;
    }

    public void func_70071_h_() {
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.prevAttackTicks = this.attackTicks;
        this.prevRetractTicks = this.retractTicks;
        if (this.attackTicks >= this.delay) {
            if (this.attackTicks == this.delay) {
                if (!this.field_70170_p.field_72995_K) {
                    List targets = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ(), e -> !e.func_190530_aW() && (!(e instanceof EntityPlayer) || !((EntityPlayer)e).func_175149_v() && !((EntityPlayer)e).func_184812_l_()));
                    if (!targets.isEmpty()) {
                        this.grabbedEntity = (EntityLivingBase)targets.get(this.field_70146_Z.nextInt(targets.size()));
                        this.grabbedEntity.func_70012_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.grabbedEntity.field_70177_z, this.grabbedEntity.field_70125_A);
                        this.grabbedEntity.field_70159_w = 0.0;
                        this.grabbedEntity.field_70179_y = 0.0;
                        this.grabbedEntity.field_70133_I = true;
                        if (this.grabbedEntity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)this.grabbedEntity).field_71135_a.func_147364_a(this.grabbedEntity.field_70165_t, this.grabbedEntity.field_70163_u, this.grabbedEntity.field_70161_v, this.grabbedEntity.field_70177_z, this.grabbedEntity.field_70125_A);
                        }
                    }
                } else {
                    this.spawnExtendParticles();
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.SPIRIT_TREE_SPIKE_TRAP, SoundCategory.HOSTILE, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, false);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.grabbedEntity != null && !((Boolean)this.field_70180_af.func_187225_a(RETRACT)).booleanValue()) {
                if (this.func_174813_aQ().func_72326_a(this.grabbedEntity.func_174813_aQ())) {
                    this.grabbedEntity.func_70690_d(new PotionEffect(ElixirEffectRegistry.ROOT_BOUND, 5, 0, true, false));
                } else {
                    this.grabbedEntity = null;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.grabbedEntity != null) {
                    if (this.attackTicks >= this.delay + this.maxAge) {
                        this.field_70180_af.func_187227_b(RETRACT, (Object)true);
                    }
                } else if (this.attackTicks >= this.delay + 20) {
                    this.field_70180_af.func_187227_b(RETRACT, (Object)true);
                }
            }
            if (((Boolean)this.field_70180_af.func_187225_a(RETRACT)).booleanValue()) {
                ++this.retractTicks;
                if (!this.field_70170_p.field_72995_K && this.getRootYOffset(1.0f) <= -2.4f) {
                    this.func_70106_y();
                }
            }
        }
        boolean retracting = (Boolean)this.field_70180_af.func_187225_a(RETRACT);
        if (this.field_70170_p.field_72995_K && (this.attackTicks <= 5 || retracting)) {
            this.spawnBlockDust();
            if (this.emergeSound && !retracting) {
                this.emergeSound = false;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.SPIRIT_TREE_SPIKE_TRAP_EMERGE, SoundCategory.HOSTILE, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, false);
            }
            if (this.retractSound && retracting) {
                this.retractSound = false;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.SPIRIT_TREE_SPIKE_TRAP_EMERGE, SoundCategory.HOSTILE, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, false);
            }
        }
        ++this.attackTicks;
        this.field_70148_d = false;
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnExtendParticles() {
        double mz;
        double my;
        double mx;
        double dz;
        double dy;
        double dx;
        int i;
        for (i = 0; i < 64; ++i) {
            dx = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 2.0;
            dy = (double)this.field_70131_O / 2.0 - 0.5;
            dz = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 2.0;
            mx = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
            my = (this.field_70146_Z.nextDouble() - 0.5) * 0.15 + 0.3;
            mz = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
            BlockPos pos = new BlockPos(this.field_70165_t + dx, (double)MathHelper.func_76128_c((double)(this.field_70163_u + dy)), this.field_70161_v + dz);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + dx, (double)(MathHelper.func_76128_c((double)(this.field_70163_u + dy)) + 1) + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + dz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)state)});
        }
        for (i = 0; i < 8; ++i) {
            dx = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 2.0;
            dy = (double)this.field_70131_O / 2.0 - 0.5;
            dz = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 2.0;
            mx = (this.field_70146_Z.nextDouble() - 0.5) * 0.2;
            my = (this.field_70146_Z.nextDouble() - 0.5) * 0.2 + 0.4;
            mz = (this.field_70146_Z.nextDouble() - 0.5) * 0.2;
            ParticleRootSpike particle = (ParticleRootSpike)BLParticles.ROOT_SPIKE.spawn(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + dy, this.field_70161_v + dz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(mx, my, mz)).withScale(0.4f));
            particle.setUseSound(this.field_70146_Z.nextInt(3) == 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnBlockDust() {
        for (int i = 0; i < 8; ++i) {
            double dx = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 2.0;
            double dy = (double)this.field_70131_O / 2.0 - 0.5;
            double dz = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 2.0;
            double mx = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
            double my = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
            double mz = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
            BlockPos pos = new BlockPos(this.field_70165_t + dx, (double)MathHelper.func_76128_c((double)(this.field_70163_u + dy)), this.field_70161_v + dz);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + dx, (double)(MathHelper.func_76128_c((double)(this.field_70163_u + dy)) + 1), this.field_70161_v + dz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public boolean func_70072_I() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_85031_j(Entity entity) {
        if (!this.field_70170_p.field_72995_K) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                this.setDamage(1.0f);
            } else {
                this.setDamage(this.getDamage() + 0.05f);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)41);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 40) {
            for (int i = 0; i < 128; ++i) {
                double dx = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / (double)2.2f;
                double dy = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70131_O / (double)1.2f + (double)(this.field_70131_O / 2.0f);
                double dz = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / (double)2.2f;
                double mx = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
                double my = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
                double mz = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + dx, this.field_70163_u + dy, this.field_70161_v + dz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)BlockRegistry.LOG_SPIRIT_TREE.func_176223_P())});
            }
            SoundType soundType = SoundType.field_185848_a;
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
        } else if (id == 41) {
            for (int i = 0; i < 8; ++i) {
                double dx = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 4.0;
                double dy = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70131_O / 2.0 + (double)(this.field_70131_O / 2.0f);
                double dz = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N / 4.0;
                double mx = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
                double my = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
                double mz = (this.field_70146_Z.nextDouble() - 0.5) * 0.15;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + dx, this.field_70163_u + dy, this.field_70161_v + dz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)BlockRegistry.LOG_SPIRIT_TREE.func_176223_P())});
            }
            SoundType soundType = SoundType.field_185848_a;
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185846_f(), SoundCategory.NEUTRAL, (soundType.func_185843_a() + 1.0f) / 8.0f, soundType.func_185847_b() * 0.5f, false);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeLong(this.origin.func_177986_g());
        data.writeInt(this.delay);
        data.writeInt(this.attackTicks);
    }

    public void readSpawnData(ByteBuf data) {
        this.origin = BlockPos.func_177969_a((long)data.readLong());
        this.delay = data.readInt();
        this.attackTicks = data.readInt();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.delay = nbt.func_74762_e("delay");
        this.origin = BlockPos.func_177969_a((long)nbt.func_74763_f("origin"));
        this.attackTicks = nbt.func_74762_e("attackTicks");
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(nbt.func_74760_g("damage")));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("delay", this.delay);
        nbt.func_74772_a("origin", this.origin.func_177986_g());
        nbt.func_74768_a("attackTicks", this.attackTicks);
        nbt.func_74776_a("damage", ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue());
    }

    @SideOnly(value=Side.CLIENT)
    public static class RootPart {
        public SpikeRenderer renderer;
        public float x;
        public float y;
        public float z;
        public float yaw;
        public float pitch;
    }
}

