/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.decay;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.CapabilityRegistry;

public class DecayEntityCapability
extends EntityCapability<DecayEntityCapability, IDecayCapability, EntityPlayer>
implements IDecayCapability,
ISerializableCapability {
    private DecayStats decayStats = new DecayStats(this);
    private int removedHealth = 0;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "decay");
    }

    @Override
    protected Capability<IDecayCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_DECAY;
    }

    @Override
    protected Class<IDecayCapability> getCapabilityClass() {
        return IDecayCapability.class;
    }

    @Override
    protected DecayEntityCapability getDefaultCapabilityImplementation() {
        return new DecayEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public DecayStats getDecayStats() {
        return this.decayStats;
    }

    @Override
    public int getRemovedHealth() {
        return this.removedHealth;
    }

    @Override
    public void setRemovedHealth(int removedHealth) {
        this.removedHealth = removedHealth;
    }

    @Override
    public float getMaxPlayerHealth(int decayLevel) {
        return Math.min(20.0f + BetweenlandsConfig.GENERAL.decayMinHealth - (float)decayLevel, 20.0f);
    }

    @Override
    public float getMaxPlayerHealthPercentage(int decayLevel) {
        return BetweenlandsConfig.GENERAL.decayMinHealthPercentage + (1.0f - BetweenlandsConfig.GENERAL.decayMinHealthPercentage) * (Math.min(26.0f - (float)decayLevel, 20.0f) - 6.0f) / 14.0f;
    }

    @Override
    public boolean isDecayEnabled() {
        return ((EntityPlayer)this.getEntity()).func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && ((EntityPlayer)this.getEntity()).field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && !((EntityPlayer)this.getEntity()).field_71075_bZ.field_75098_d && !((EntityPlayer)this.getEntity()).field_71075_bZ.field_75102_a;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        this.decayStats.writeNBT(nbt);
        nbt.func_74768_a("removedHealth", this.removedHealth);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.decayStats.readNBT(nbt);
        this.removedHealth = nbt.func_74762_e("removedHealth");
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 10;
    }
}

