/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityDugSoil;
import thebetweenlands.common.world.gen.biome.decorator.DecorationHelper;
import thebetweenlands.common.world.gen.biome.decorator.DecoratorPositionProvider;

public class BlockSwampGrass
extends BasicBlock
implements IGrowable,
ITintedBlock {
    public BlockSwampGrass() {
        super(Material.field_151577_b);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            BlockSwampGrass.updateGrass(worldIn, pos, rand);
        }
    }

    public static boolean updateGrass(World world, BlockPos pos, Random rand) {
        if (world.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
            BlockSwampGrass.revertToDirt(world, pos);
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            BlockPos blockPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
            if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && !world.func_175667_e(blockPos)) {
                return false;
            }
            IBlockState blockStateAbove = world.func_180495_p(blockPos.func_177984_a());
            if (blockStateAbove.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) continue;
            BlockSwampGrass.spreadGrassTo(world, blockPos);
            return true;
        }
        return false;
    }

    public static void revertToDirt(World world, BlockPos pos) {
        TileEntityDugSoil te;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == BlockRegistry.SWAMP_GRASS) {
            world.func_175656_a(pos, BlockRegistry.SWAMP_DIRT.func_176223_P());
        }
        if ((te = BlockGenericDugSoil.getTile(world, pos)) != null) {
            int compost = te.getCompost();
            int decay = te.getDecay();
            if (state.func_177230_c() == BlockRegistry.DUG_SWAMP_GRASS) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_DIRT.func_176223_P());
            }
            if (state.func_177230_c() == BlockRegistry.DUG_PURIFIED_SWAMP_GRASS) {
                world.func_175656_a(pos, BlockRegistry.DUG_PURIFIED_SWAMP_DIRT.func_176223_P());
            }
            if ((te = BlockGenericDugSoil.getTile(world, pos)) != null) {
                te.setCompost(compost);
                te.setDecay(decay);
            }
        }
    }

    public static void spreadGrassTo(World world, BlockPos pos) {
        TileEntityDugSoil te;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == BlockRegistry.SWAMP_DIRT) {
            world.func_175656_a(pos, BlockRegistry.SWAMP_GRASS.func_176223_P());
        }
        if ((te = BlockGenericDugSoil.getTile(world, pos)) != null) {
            int compost = te.getCompost();
            int decay = te.getDecay();
            if (state.func_177230_c() == BlockRegistry.DUG_SWAMP_DIRT) {
                world.func_180501_a(pos, BlockRegistry.DUG_SWAMP_GRASS.func_176223_P(), 2);
            }
            if (state.func_177230_c() == BlockRegistry.DUG_PURIFIED_SWAMP_DIRT) {
                world.func_180501_a(pos, BlockRegistry.DUG_PURIFIED_SWAMP_GRASS.func_176223_P(), 2);
            }
            if ((te = BlockGenericDugSoil.getTile(world, pos)) != null) {
                te.setCompost(compost);
                te.setDecay(decay);
            }
            world.func_184138_a(pos, state, world.func_180495_p(pos), 1);
        }
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockRegistry.SWAMP_DIRT.func_180660_a(BlockRegistry.SWAMP_DIRT.func_176223_P(), rand, fortune);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        DecoratorPositionProvider provider = new DecoratorPositionProvider();
        provider.init(worldIn, worldIn.func_180494_b(pos), null, rand, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        provider.setOffsetXZ(-4, 4);
        provider.setOffsetY(-2, 2);
        for (int i = 0; i < 4; ++i) {
            DecorationHelper.generateSwampDoubleTallgrass(provider);
            DecorationHelper.generateTallCattail(provider);
            DecorationHelper.generateSwampTallgrassCluster(provider);
            if (rand.nextInt(5) == 0) {
                DecorationHelper.generateCattailCluster(provider);
            }
            if (rand.nextInt(3) != 0) continue;
            DecorationHelper.generateShootsCluster(provider);
        }
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (super.canSustainPlant(state, world, pos, direction, plantable)) {
            return true;
        }
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Beach: {
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return hasWater;
            }
            case Plains: {
                return true;
            }
        }
        return false;
    }
}

