/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.item.ItemBlockEnum;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockPortalFrame
extends BasicBlock
implements BlockRegistry.ICustomItemBlock,
BlockRegistry.ISubtypeItemBlockModelDefinition {
    public static final PropertyEnum<EnumPortalFrame> FRAME_POSITION = PropertyEnum.func_177709_a((String)"frame_position", EnumPortalFrame.class);
    public static final PropertyBool X_AXIS = PropertyBool.func_177716_a((String)"x_axis");

    public BlockPortalFrame() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FRAME_POSITION, (Comparable)((Object)EnumPortalFrame.CORNER_TOP_LEFT)).func_177226_a((IProperty)X_AXIS, (Comparable)Boolean.valueOf(false)));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        IBlockState dropBlock = BlockRegistry.LOG_PORTAL.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        drops.add(new ItemStack(Item.func_150898_a((Block)dropBlock.func_177230_c()), 1, dropBlock.func_177230_c().func_176201_c(dropBlock)));
        return drops;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumPortalFrame type : EnumPortalFrame.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FRAME_POSITION, X_AXIS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FRAME_POSITION, (Comparable)((Object)EnumPortalFrame.values()[meta > 7 ? meta - 8 : meta])).func_177226_a((IProperty)X_AXIS, (Comparable)Boolean.valueOf(meta > 7));
    }

    public int func_176201_c(IBlockState state) {
        EnumPortalFrame type = (EnumPortalFrame)((Object)state.func_177229_b(FRAME_POSITION));
        return type.ordinal() + ((Boolean)state.func_177229_b((IProperty)X_AXIS) != false ? 8 : 0);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return super.func_180643_i(this.func_176223_P().func_177226_a(FRAME_POSITION, state.func_177229_b(FRAME_POSITION)));
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumPortalFrame.class);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)X_AXIS, (Comparable)Boolean.valueOf(true)));
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getSubtypeNumber() {
        return EnumPortalFrame.values().length;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + EnumPortalFrame.values()[meta].func_176610_l();
    }

    public static enum EnumPortalFrame implements IStringSerializable
    {
        CORNER_TOP_LEFT,
        TOP,
        CORNER_TOP_RIGHT,
        SIDE_RIGHT,
        SIDE_LEFT,
        CORNER_BOTTOM_LEFT,
        BOTTOM,
        CORNER_BOTTOM_RIGHT;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public String func_176610_l() {
            return this.name;
        }
    }
}

