/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.common.block.farming.BlockGenericCrop;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.item.herblore.ItemAspectVial;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityAspectrusCrop;
import thebetweenlands.common.tile.TileEntityDugSoil;

public class BlockAspectrusCrop
extends BlockGenericCrop
implements BlockRegistry.ICustomItemBlock,
ITileEntityProvider {
    protected static final float ASPECT_FRUIT_MULTIPLIER = 0.5f;
    protected static final int ASPECT_SEEDS_DEGRADATION = 180;
    protected static final int MAX_HEIGHT = 3;
    protected static final int DECAY_CHANCE = 15;

    public BlockAspectrusCrop() {
        this.func_149647_a(null);
        this.setMaxHeight(3);
    }

    public void setAspect(IBlockAccess world, BlockPos pos, @Nullable Aspect aspect) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAspectrusCrop) {
            ((TileEntityAspectrusCrop)tile).setAspect(aspect);
        }
    }

    @Nullable
    public Aspect getAspect(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAspectrusCrop) {
            return ((TileEntityAspectrusCrop)tile).getAspect();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemAspectContainer aspectContainer;
        List<Aspect> aspects;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemAspectVial && this.getAspect((IBlockAccess)world, pos) == null && !(aspects = (aspectContainer = ItemAspectContainer.fromItem(stack)).getAspects()).isEmpty()) {
            Aspect aspect = aspects.get(0);
            if (!world.field_72995_K) {
                this.setAspect((IBlockAccess)world, pos, aspect);
                if (!player.func_184812_l_()) {
                    player.func_184611_a(hand, stack.func_77973_b().getContainerItem(stack));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        Aspect aspect = this.getAspect((IBlockAccess)worldIn, pos);
        if (aspect != null && worldIn.field_73012_v.nextInt(Math.max((int)(15.0f - (float)aspect.amount / 1000.0f * 15.0f), 2)) == 0) {
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
            checkPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
            for (int i = 0; i < 3; ++i) {
                IBlockState offsetState = worldIn.func_180495_p((BlockPos)checkPos);
                if (offsetState.func_177230_c() instanceof BlockGenericDugSoil) {
                    TileEntityDugSoil te;
                    if (((BlockGenericDugSoil)offsetState.func_177230_c()).isPurified(worldIn, (BlockPos)checkPos, offsetState) || (te = BlockGenericDugSoil.getTile(worldIn, (BlockPos)checkPos)) == null || te.isFullyDecayed()) break;
                    te.setDecay(te.getDecay() + 5);
                    break;
                }
                checkPos.func_181079_c(checkPos.func_177958_n(), checkPos.func_177956_o() - 1, checkPos.func_177952_p());
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BlockFence.field_185671_f;
    }

    @Override
    protected boolean removePlant(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        return world.func_180501_a(pos, BlockRegistry.RUBBER_TREE_PLANK_FENCE.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    @Override
    public int getCropDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            return 1 + rand.nextInt(3 + fortune);
        }
        return 0;
    }

    @Override
    public int getSeedDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            return 1 + (rand.nextInt(8) == 0 ? 1 : 0);
        }
        return 1;
    }

    @Override
    protected boolean canGrow(World world, BlockPos pos, IBlockState state) {
        Aspect aspect = this.getAspect((IBlockAccess)world, pos);
        return aspect != null;
    }

    @Override
    protected float getGrowthChance(World world, BlockPos pos, IBlockState state, Random rand) {
        Aspect aspect = this.getAspect((IBlockAccess)world, pos);
        return 1.0f / (1.0f + (float)aspect.amount / 1000.0f * 8.0f);
    }

    @Override
    protected boolean canGrowUp(World world, BlockPos pos, IBlockState state, int height) {
        BlockPos posUp;
        IBlockState upState;
        if ((this.maxHeight == -1 || height < this.maxHeight) && (upState = world.func_180495_p(posUp = pos.func_177984_a())).func_177230_c() == BlockRegistry.RUBBER_TREE_PLANK_FENCE) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                if (!BlockRegistry.RUBBER_TREE_PLANK_FENCE.canBeConnectedTo((IBlockAccess)world, posUp, dir)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void growUp(World world, BlockPos pos) {
        BlockPos posUp;
        IBlockState stateUp;
        super.growUp(world, pos);
        Aspect aspect = this.getAspect((IBlockAccess)world, pos);
        if (aspect != null && (stateUp = world.func_180495_p(posUp = pos.func_177984_a())).func_177230_c() instanceof BlockAspectrusCrop) {
            ((BlockAspectrusCrop)stateUp.func_177230_c()).setAspect((IBlockAccess)world, posUp, aspect);
        }
    }

    @Override
    protected PropertyInteger createStageProperty() {
        return PropertyInteger.func_177719_a((String)"stage", (int)0, (int)15);
    }

    @Override
    public ItemStack getSeedDrop(IBlockAccess world, BlockPos pos, Random rand) {
        ItemStack stack = new ItemStack(ItemRegistry.ASPECTRUS_SEEDS);
        Aspect aspect = this.getAspect(world, pos);
        if (aspect != null && aspect.amount - 180 > 0) {
            ItemAspectContainer.fromItem(stack).set(aspect.type, aspect.amount - 180);
        }
        return stack;
    }

    @Override
    public ItemStack getCropDrop(IBlockAccess world, BlockPos pos, Random rand) {
        if (!this.isDecayed(world, pos)) {
            ItemStack stack = new ItemStack(ItemRegistry.ASPECTRUS_FRUIT);
            Aspect aspect = this.getAspect(world, pos);
            if (aspect != null) {
                ItemAspectContainer.fromItem(stack).set(aspect.type, MathHelper.func_76141_d((float)((float)aspect.amount * 0.5f)));
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemRegistry.ASPECTRUS_SEEDS);
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityAspectrusCrop();
    }

    @Override
    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE) + (rand.nextInt(2) == 0 ? 1 : 0);
        if (age > 15) {
            age = 15;
            int height = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(height)).func_177230_c() == this) {
                ++height;
            }
            if (this.canGrowUp(worldIn, pos, state, height)) {
                this.growUp(worldIn, pos);
            }
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)));
    }
}

