/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import com.google.common.base.Predicate;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.entity.mobs.EntityTermite;
import thebetweenlands.common.item.ItemBlockEnum;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityLootInventory;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.util.AdvancedStateMap;

public class BlockLootPot
extends BasicBlock
implements ITileEntityProvider,
BlockRegistry.ICustomItemBlock,
BlockRegistry.ISubtypeItemBlockModelDefinition,
BlockRegistry.IStateMappedBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumLootPot> VARIANT = PropertyEnum.func_177709_a((String)"type", EnumLootPot.class);

    public BlockLootPot() {
        this(Material.field_151592_s);
    }

    public BlockLootPot(Material material) {
        super(material);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(VARIANT, (Comparable)((Object)EnumLootPot.POT_1)));
    }

    @Nullable
    public static TileEntityLootPot getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLootPot) {
            return (TileEntityLootPot)tile;
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityLootPot();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, EnumLootPot.POT_1.getMetadata(EnumFacing.SOUTH)));
        list.add((Object)new ItemStack((Block)this, 1, EnumLootPot.POT_2.getMetadata(EnumFacing.SOUTH)));
        list.add((Object)new ItemStack((Block)this, 1, EnumLootPot.POT_3.getMetadata(EnumFacing.SOUTH)));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((EnumLootPot)((Object)state.func_177229_b(VARIANT))).getMetadata(EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumLootPot.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumLootPot)((Object)state.func_177229_b(VARIANT))).getMetadata((EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)rotation));
        state = state.func_177226_a(VARIANT, (Comparable)((Object)EnumLootPot.byMetadata(stack.func_77952_i())));
        worldIn.func_180501_a(pos, state, 3);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLootPot) {
            ((TileEntityLootPot)tile).setModelRotationOffset(worldIn.field_73012_v.nextInt(41) - 20);
            ((TileEntityLootPot)tile).setLootTable(LootTableRegistry.COMMON_POT_LOOT, worldIn.field_73012_v.nextLong());
            tile.func_70296_d();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175625_s(pos) instanceof TileEntityLootPot) {
                TileEntityLootPot tile = (TileEntityLootPot)worldIn.func_175625_s(pos);
                InvWrapper wrapper = new InvWrapper((IInventory)tile);
                if (!playerIn.func_184586_b(hand).func_190926_b()) {
                    ItemStack stack = playerIn.func_184586_b(hand);
                    ItemStack prevStack = stack.func_77946_l();
                    for (int i = 0; i < wrapper.getSlots() && !stack.func_190926_b(); ++i) {
                        stack = wrapper.insertItem(i, stack, false);
                    }
                    if (stack.func_190926_b() || stack.func_190916_E() != prevStack.func_190916_E()) {
                        if (!playerIn.func_184812_l_()) {
                            playerIn.func_184611_a(hand, stack);
                        }
                        return true;
                    }
                } else if (playerIn.func_70093_af() && hand == EnumHand.MAIN_HAND) {
                    for (int i = 0; i < wrapper.getSlots(); ++i) {
                        ItemStack extracted = wrapper.extractItem(i, 1, false);
                        if (extracted.func_190926_b()) continue;
                        EntityItem item = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, extracted);
                        item.field_70179_y = 0.0;
                        item.field_70181_x = 0.0;
                        item.field_70159_w = 0.0;
                        worldIn.func_72838_d((Entity)item);
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        IInventory tile = (IInventory)worldIn.func_175625_s(pos);
        if (tile != null) {
            ((TileEntityLootInventory)tile).fillInventoryWithLoot(player);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IInventory tile = (IInventory)worldIn.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(3) == 0) {
            EntityTermite entity = new EntityTermite(worldIn);
            entity.func_110148_a(EntityTermite.SMALL).func_111128_a(1.0);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)entity);
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    public int getSubtypeNumber() {
        return EnumLootPot.values().length * 4;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + EnumLootPot.byMetadata(meta).func_176610_l();
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumLootPot.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{VARIANT}).withPropertySuffix(VARIANT, e -> e.func_176610_l());
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumLootPot implements IStringSerializable,
    ItemBlockEnum.IGenericMetaSelector
    {
        POT_1("1"),
        POT_2("2"),
        POT_3("3");

        private final String name;

        private EnumLootPot(String name) {
            this.name = name.toLowerCase(Locale.ENGLISH);
        }

        public int getMetadata(EnumFacing facing) {
            return facing.func_176736_b() | this.ordinal() << 2;
        }

        public String toString() {
            return this.name;
        }

        public static EnumLootPot byMetadata(int metadata) {
            if ((metadata >>= 2) < 0 || metadata >= EnumLootPot.values().length) {
                metadata = 0;
            }
            return EnumLootPot.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public boolean isMetadataMatching(int meta) {
            return EnumLootPot.byMetadata(meta) == this;
        }
    }
}

