/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import thebetweenlands.client.render.model.tile.ModelCompostBin;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityCompostBin;

public class RenderCompostBin
extends TileEntitySpecialRenderer<TileEntityCompostBin> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/compost_bin.png");
    public static final ModelCompostBin MODEL = new ModelCompostBin();
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public void render(TileEntityCompostBin te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float compostHeight;
        int meta = te != null ? te.func_145832_p() : 0;
        float f = compostHeight = te != null ? Math.min((float)te.getCompostedAmount() / 400.0f, 0.82f) : 0.0f;
        if (compostHeight > 0.01f) {
            IBlockState compost = BlockRegistry.COMPOST_BLOCK.func_176223_P();
            BlockPos blockPos = te.func_174877_v();
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.005), (double)(z + 0.5));
            GlStateManager.func_179152_a((float)0.8f, (float)compostHeight, (float)0.8f);
            GlStateManager.func_179137_b((double)((double)(-((float)blockPos.func_177958_n())) - 0.5), (double)(-((float)blockPos.func_177956_o())), (double)((double)(-((float)blockPos.func_177952_p())) - 0.5));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            blockRenderer.func_175019_b().func_187493_a((IBlockAccess)te.func_145831_w(), blockRenderer.func_184389_a(compost), compost, blockPos, vertexbuffer, false, MathHelper.func_180186_a((Vec3i)blockPos));
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)RenderCompostBin.getRotation(meta), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179129_p();
        this.func_147499_a(TEXTURE);
        MODEL.render(te != null ? te.getLidAngle(partialTicks) : 0.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (te != null) {
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack stack = te.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)(0.005f + compostHeight + (float)i * 0.4f / (float)te.func_70302_i_()), (float)0.08f);
                GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
                GlStateManager.func_179114_b((float)(new Random(i * 12315).nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
    }

    public static float getRotation(int meta) {
        switch (meta) {
            case 5: {
                return 180.0f;
            }
            default: {
                return 0.0f;
            }
            case 3: {
                return 90.0f;
            }
            case 2: 
        }
        return -90.0f;
    }
}

