/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.loader;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.Validate;
import thebetweenlands.client.render.model.loader.CustomModelLoader;
import thebetweenlands.client.render.model.loader.IModelVariantProvider;

public enum CustomModelManager {
    INSTANCE;

    private final CustomModelLoader loader = new CustomModelLoader(this);
    private final Map<ResourceLocation, Function<ResourceLocation, IModel>> registeredModelProviders = new HashMap<ResourceLocation, Function<ResourceLocation, IModel>>();

    public void registerLoader() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this.loader);
        MinecraftForge.EVENT_BUS.register((Object)this.loader);
    }

    public CustomModelLoader getLoader() {
        return this.loader;
    }

    public Map<ResourceLocation, Function<ResourceLocation, IModel>> getRegisteredModelProviders() {
        return Collections.unmodifiableMap(this.registeredModelProviders);
    }

    private void registerModelProvider(@Nonnull ResourceLocation modelLocation, @Nonnull Function<ResourceLocation, IModel> modelGetter) {
        Validate.notNull((Object)modelLocation);
        Validate.notNull(modelGetter);
        this.registeredModelProviders.put(modelLocation, modelGetter);
    }

    public void registerModel(@Nonnull ResourceLocation modelLocation, @Nonnull IModel model) {
        Validate.notNull((Object)modelLocation);
        Validate.notNull((Object)model);
        if (model instanceof IModelVariantProvider) {
            this.registerModelProvider(modelLocation, (Function<ResourceLocation, IModel>)((Function)location -> ((IModelVariantProvider)model).getModelVariant((ResourceLocation)location)));
        } else {
            this.registerModelProvider(modelLocation, (Function<ResourceLocation, IModel>)((Function)location -> model));
        }
    }
}

