/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import thebetweenlands.client.render.model.baked.ModelFromModelBase;
import thebetweenlands.client.render.model.baked.modelbase.shields.ModelWeedwoodShield;
import thebetweenlands.common.registries.ModelRegistry;
import thebetweenlands.util.ModelConverter;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.TexturePacker;

public class ModelWeedwoodShieldBurning
extends ModelFromModelBase {
    public static final ResourceLocation FIRE_TEXTURE_LOCATION = new ResourceLocation("minecraft:blocks/fire_layer_0");

    public ModelWeedwoodShieldBurning(TexturePacker packer) {
        super(packer, new ModelWeedwoodShield(), new ResourceLocation("thebetweenlands:items/shields/weedwood_shield"), new ResourceLocation("thebetweenlands:particle/item/weedwood_shield_particle"), 64, 64, ModelRegistry.SHIELD_VERTEX_PROCESSOR);
        this.usedTextures.add(FIRE_TEXTURE_LOCATION);
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new ModelBakedWeedwoodShieldBurning(this.vertexProcessor, (Optional<TRSRTransformation>)state.apply(Optional.empty()), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format, this.convertedModel, bakedTextureGetter, bakedTextureGetter.apply(this.texture), bakedTextureGetter.apply(FIRE_TEXTURE_LOCATION), this.width, this.height);
    }

    public static class ModelBakedWeedwoodShieldBurning
    extends ModelFromModelBase.ModelBakedModelBase {
        protected ModelBakedWeedwoodShieldBurning(ModelFromModelBase.IVertexProcessor vertexProcessor, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, ModelConverter.Model convertedModel, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, TextureAtlasSprite particleTexture, TextureAtlasSprite flameSprite, int width, int height) {
            super(vertexProcessor, transformation, transforms, format, convertedModel, bakedTextureGetter, particleTexture, width, height, true);
            QuadBuilder builder = new QuadBuilder(this.format).setSprite(flameSprite);
            for (int i = 0; i < 4; ++i) {
                builder.addVertexInferUV(new Vec3d(-0.5, 0.5 + (double)i / 4.0, 0.35 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(-0.5, -0.5 + (double)i / 4.0, 0.15 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(0.5, -0.5 + (double)i / 4.0, 0.15 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(0.5, 0.5 + (double)i / 4.0, 0.35 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(0.5, 0.5 + (double)i / 4.0, 0.3 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(0.5, -0.5 + (double)i / 4.0, 0.1 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(-0.5, -0.5 + (double)i / 4.0, 0.1 - (double)i / 16.0));
                builder.addVertexInferUV(new Vec3d(-0.5, 0.5 + (double)i / 4.0, 0.3 - (double)i / 16.0));
            }
            ImmutableList.Builder combinedQuads = ImmutableList.builder();
            combinedQuads.addAll((Iterable)this.quads);
            combinedQuads.addAll(builder.build().nonCulledQuads);
            this.quads = combinedQuads.build();
        }
    }
}

