/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelSwordEnergy;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.EntitySwordEnergy;
import thebetweenlands.common.item.misc.ItemMisc;

@SideOnly(value=Side.CLIENT)
public class RenderSwordEnergy
extends Render<EntitySwordEnergy> {
    private static final ResourceLocation FORCE_TEXTURE = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private static ModelSwordEnergy model = new ModelSwordEnergy();
    private final ItemStack swordPiece1 = ItemMisc.EnumItemMisc.SHOCKWAVE_SWORD_1.create(1);
    private final ItemStack swordPiece2 = ItemMisc.EnumItemMisc.SHOCKWAVE_SWORD_2.create(1);
    private final ItemStack swordPiece3 = ItemMisc.EnumItemMisc.SHOCKWAVE_SWORD_3.create(1);
    private final ItemStack swordPiece4 = ItemMisc.EnumItemMisc.SHOCKWAVE_SWORD_4.create(1);

    public RenderSwordEnergy(RenderManager rendermanagerIn) {
        super(rendermanagerIn);
    }

    public void doRender(EntitySwordEnergy entity, double x, double y, double z, float rotationYaw, float partialTickTime) {
        this.renderSwordEnergy(entity, x, y, z, rotationYaw, partialTickTime);
    }

    public void renderSwordEnergy(EntitySwordEnergy energyBall, double x, double y, double z, float rotationYaw, float partialTickTime) {
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(energyBall.field_70165_t, energyBall.field_70163_u + 0.5, energyBall.field_70161_v, 2.0f, 0.25490198f, 2.0392158f, 3.0588236f));
        }
        float ticks = (float)energyBall.field_70173_aa + partialTickTime;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y - 0.0625 - (double)energyBall.pulseFloat), (double)z);
        float f1 = ticks;
        this.func_110776_a(FORCE_TEXTURE);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        float f2 = f1 * 0.01f;
        float f3 = f1 * 0.01f;
        GlStateManager.func_179109_b((float)f2, (float)f3, (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179147_l();
        float f4 = 0.5f;
        GlStateManager.func_179131_c((float)f4, (float)f4, (float)f4, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179152_a((float)(1.0f + energyBall.pulseFloat), (float)(1.0f + energyBall.pulseFloat), (float)(1.0f + energyBall.pulseFloat));
        model.render(0.0625f);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        double interpPos1 = energyBall.lastPos1 + (energyBall.pos1 - energyBall.lastPos1) * partialTickTime;
        this.renderItemInBlock(x - interpPos1, y + (double)0.725f, z - interpPos1, this.swordPiece1, ticks);
        double interpPos2 = energyBall.lastPos2 + (energyBall.pos2 - energyBall.lastPos2) * partialTickTime;
        this.renderItemInBlock(x + interpPos2, y + (double)0.725f, z - interpPos2, this.swordPiece2, ticks);
        double interpPos3 = energyBall.lastPos3 + (energyBall.pos3 - energyBall.lastPos3) * partialTickTime;
        this.renderItemInBlock(x + interpPos3, y + (double)0.725f, z + interpPos3, this.swordPiece3, ticks);
        double interpPos4 = energyBall.lastPos4 + (energyBall.pos4 - energyBall.lastPos4) * partialTickTime;
        this.renderItemInBlock(x - interpPos4, y + (double)0.725f, z + interpPos4, this.swordPiece4, ticks);
        this.func_110776_a(FORCE_TEXTURE);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)f2, (float)0.0f, (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)f4, (float)f4, (float)f4, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179098_w();
        GlStateManager.func_179129_p();
        RenderSwordEnergy.renderBeam(new Vec3d(x, y + (double)0.85f, z), new Vec3d(x - interpPos1 - (double)0.1f, y + (double)0.9f, z - interpPos1 - (double)0.1f), 0.05f, 0.25f, true, true);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x - interpPos1), (double)(y - (double)0.14f), (double)(z - interpPos1));
        if (energyBall.pos1 < 3.5f) {
            model.render(0.0625f);
        }
        GlStateManager.func_179121_F();
        RenderSwordEnergy.renderBeam(new Vec3d(x, y + (double)0.85f, z), new Vec3d(x + interpPos2 + (double)0.1f, y + (double)0.9f, z - interpPos2 - (double)0.1f), 0.05f, 0.25f, true, true);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + interpPos2), (double)(y - (double)0.14f), (double)(z - interpPos2));
        if (energyBall.pos2 < 3.5f) {
            model.render(0.0625f);
        }
        GlStateManager.func_179121_F();
        RenderSwordEnergy.renderBeam(new Vec3d(x, y + (double)0.85f, z), new Vec3d(x + interpPos3 + (double)0.1f, y + (double)0.9f, z + interpPos3 + (double)0.1f), 0.05f, 0.25f, true, true);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + interpPos3), (double)(y - (double)0.14f), (double)(z + interpPos3));
        if (energyBall.pos3 < 3.5f) {
            model.render(0.0625f);
        }
        GlStateManager.func_179121_F();
        RenderSwordEnergy.renderBeam(new Vec3d(x, y + (double)0.85f, z), new Vec3d(x - interpPos4 - (double)0.1f, y + (double)0.9f, z + interpPos4 + (double)0.1f), 0.05f, 0.25f, true, true);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x - interpPos4), (double)(y - (double)0.14f), (double)(z + interpPos4));
        if (energyBall.pos4 < 3.5f) {
            model.render(0.0625f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
    }

    public void renderItemInBlock(double x, double y, double z, ItemStack item, float ticks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179152_a((float)1.25f, (float)1.25f, (float)1.25f);
        GlStateManager.func_179114_b((float)(ticks * 4.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(item, ItemCameraTransforms.TransformType.GROUND);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntitySwordEnergy entity) {
        return null;
    }

    public static void renderBeam(Vec3d start, Vec3d end, float startWidth, float endWidth, boolean renderStartCap, boolean renderEndCap) {
        Vec3d diff = start.func_178788_d(end);
        Vec3d dir = diff.func_72432_b();
        Vec3d upVec = new Vec3d(0.0, 1.0, 0.0);
        Vec3d localSide = dir.func_72431_c(upVec).func_72432_b();
        Vec3d localUp = localSide.func_72431_c(dir).func_72432_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        double maxVStart = diff.func_72433_c() / 8.0;
        double maxVEnd = diff.func_72433_c() / 8.0;
        double minVStart = 0.0;
        double minVEnd = 0.0;
        double maxU = diff.func_72433_c() / 2.0;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(start.field_72450_a + (localSide.field_72450_a + localUp.field_72450_a) * (double)startWidth, start.field_72448_b + (localSide.field_72448_b + localUp.field_72448_b) * (double)startWidth, start.field_72449_c + (localSide.field_72449_c + localUp.field_72449_c) * (double)startWidth).func_187315_a(0.0, minVStart).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (localSide.field_72450_a - localUp.field_72450_a) * (double)startWidth, start.field_72448_b + (localSide.field_72448_b - localUp.field_72448_b) * (double)startWidth, start.field_72449_c + (localSide.field_72449_c - localUp.field_72449_c) * (double)startWidth).func_187315_a(0.0, maxVStart).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (localSide.field_72450_a - localUp.field_72450_a) * (double)endWidth, end.field_72448_b + (localSide.field_72448_b - localUp.field_72448_b) * (double)endWidth, end.field_72449_c + (localSide.field_72449_c - localUp.field_72449_c) * (double)endWidth).func_187315_a(maxU, maxVEnd).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (localSide.field_72450_a + localUp.field_72450_a) * (double)endWidth, end.field_72448_b + (localSide.field_72448_b + localUp.field_72448_b) * (double)endWidth, end.field_72449_c + (localSide.field_72449_c + localUp.field_72449_c) * (double)endWidth).func_187315_a(maxU, minVEnd).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (-localSide.field_72450_a + localUp.field_72450_a) * (double)endWidth, end.field_72448_b + (-localSide.field_72448_b + localUp.field_72448_b) * (double)endWidth, end.field_72449_c + (-localSide.field_72449_c + localUp.field_72449_c) * (double)endWidth).func_187315_a(maxU, minVEnd).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (-localSide.field_72450_a - localUp.field_72450_a) * (double)endWidth, end.field_72448_b + (-localSide.field_72448_b - localUp.field_72448_b) * (double)endWidth, end.field_72449_c + (-localSide.field_72449_c - localUp.field_72449_c) * (double)endWidth).func_187315_a(maxU, maxVEnd).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (-localSide.field_72450_a - localUp.field_72450_a) * (double)startWidth, start.field_72448_b + (-localSide.field_72448_b - localUp.field_72448_b) * (double)startWidth, start.field_72449_c + (-localSide.field_72449_c - localUp.field_72449_c) * (double)startWidth).func_187315_a(0.0, maxVStart).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (-localSide.field_72450_a + localUp.field_72450_a) * (double)startWidth, start.field_72448_b + (-localSide.field_72448_b + localUp.field_72448_b) * (double)startWidth, start.field_72449_c + (-localSide.field_72449_c + localUp.field_72449_c) * (double)startWidth).func_187315_a(0.0, minVStart).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (localUp.field_72450_a + localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (localUp.field_72448_b + localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (localUp.field_72449_c + localSide.field_72449_c) * (double)endWidth).func_187315_a(maxU, minVEnd).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (localUp.field_72450_a - localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (localUp.field_72448_b - localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (localUp.field_72449_c - localSide.field_72449_c) * (double)endWidth).func_187315_a(maxU, maxVEnd).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (localUp.field_72450_a - localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (localUp.field_72448_b - localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (localUp.field_72449_c - localSide.field_72449_c) * (double)startWidth).func_187315_a(0.0, maxVStart).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (localUp.field_72450_a + localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (localUp.field_72448_b + localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (localUp.field_72449_c + localSide.field_72449_c) * (double)startWidth).func_187315_a(0.0, minVStart).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (-localUp.field_72450_a + localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (-localUp.field_72448_b + localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (-localUp.field_72449_c + localSide.field_72449_c) * (double)startWidth).func_187315_a(0.0, minVStart).func_181675_d();
        vertexbuffer.func_181662_b(start.field_72450_a + (-localUp.field_72450_a - localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (-localUp.field_72448_b - localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (-localUp.field_72449_c - localSide.field_72449_c) * (double)startWidth).func_187315_a(0.0, maxVStart).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (-localUp.field_72450_a - localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (-localUp.field_72448_b - localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (-localUp.field_72449_c - localSide.field_72449_c) * (double)endWidth).func_187315_a(maxU, maxVEnd).func_181675_d();
        vertexbuffer.func_181662_b(end.field_72450_a + (-localUp.field_72450_a + localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (-localUp.field_72448_b + localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (-localUp.field_72449_c + localSide.field_72449_c) * (double)endWidth).func_187315_a(maxU, minVEnd).func_181675_d();
        if (renderStartCap) {
            vertexbuffer.func_181662_b(start.field_72450_a + (localUp.field_72450_a - localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (localUp.field_72448_b - localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (localUp.field_72449_c - localSide.field_72449_c) * (double)startWidth).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(start.field_72450_a + (-localUp.field_72450_a - localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (-localUp.field_72448_b - localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (-localUp.field_72449_c - localSide.field_72449_c) * (double)startWidth).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(start.field_72450_a + (-localUp.field_72450_a + localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (-localUp.field_72448_b + localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (-localUp.field_72449_c + localSide.field_72449_c) * (double)startWidth).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(start.field_72450_a + (localUp.field_72450_a + localSide.field_72450_a) * (double)startWidth, start.field_72448_b + (localUp.field_72448_b + localSide.field_72448_b) * (double)startWidth, start.field_72449_c + (localUp.field_72449_c + localSide.field_72449_c) * (double)startWidth).func_187315_a(0.0, 0.0).func_181675_d();
        }
        if (renderEndCap) {
            vertexbuffer.func_181662_b(end.field_72450_a + (localUp.field_72450_a + localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (localUp.field_72448_b + localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (localUp.field_72449_c + localSide.field_72449_c) * (double)endWidth).func_187315_a(0.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(end.field_72450_a + (-localUp.field_72450_a + localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (-localUp.field_72448_b + localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (-localUp.field_72449_c + localSide.field_72449_c) * (double)endWidth).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(end.field_72450_a + (-localUp.field_72450_a - localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (-localUp.field_72448_b - localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (-localUp.field_72449_c - localSide.field_72449_c) * (double)endWidth).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(end.field_72450_a + (localUp.field_72450_a - localSide.field_72450_a) * (double)endWidth, end.field_72448_b + (localUp.field_72448_b - localSide.field_72448_b) * (double)endWidth, end.field_72449_c + (localUp.field_72449_c - localSide.field_72449_c) * (double)endWidth).func_187315_a(0.0, 1.0).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

