/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.RenderWallFace;
import thebetweenlands.client.render.entity.layer.LayerOverlay;
import thebetweenlands.client.render.model.entity.ModelSpiritTreeFaceSmall1;
import thebetweenlands.client.render.model.entity.ModelSpiritTreeFaceSmall2;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceSmall;

@SideOnly(value=Side.CLIENT)
public class RenderSpiritTreeFaceSmall
extends RenderWallFace<EntitySpiritTreeFaceSmall> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/spirit_tree_face_small.png");
    private final ModelSpiritTreeFaceSmall1 model1 = new ModelSpiritTreeFaceSmall1();
    private final ModelSpiritTreeFaceSmall2 model2 = new ModelSpiritTreeFaceSmall2();
    protected final LayerOverlay<EntitySpiritTreeFaceSmall> glow;

    public RenderSpiritTreeFaceSmall(RenderManager renderManager) {
        super(renderManager, new ModelSpiritTreeFaceSmall1(), 0.0f);
        this.func_177094_a(new LayerOverlay<EntitySpiritTreeFaceSmall>((RenderLivingBase)this){

            @Override
            protected ResourceLocation getTexture(EntitySpiritTreeFaceSmall entity, int index) {
                int damage = MathHelper.func_76123_f((float)((1.0f - entity.func_110143_aJ() / entity.func_110138_aP()) * 10.0f));
                if (damage > 0 && damage <= 10) {
                    return DESTROY_STAGES[damage - 1];
                }
                return null;
            }

            @Override
            protected void renderOverlay(EntitySpiritTreeFaceSmall entity, ModelBase model, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                this.preRenderDamagedBlocks();
                super.renderOverlay(entity, model, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                this.postRenderDamagedBlocks();
            }

            private void preRenderDamagedBlocks() {
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179096_D();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)0.0f);
                GlStateManager.func_179128_n((int)5888);
            }

            private void postRenderDamagedBlocks() {
                GlStateManager.func_179118_c();
                GlStateManager.func_179141_d();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        });
        this.glow = new LayerOverlay(this, new ResourceLocation("thebetweenlands", "textures/entity/spirit_tree_face_small_glow.png")).setGlow(true);
        this.func_177094_a(this.glow);
    }

    @Override
    protected void preRenderCallback(EntitySpiritTreeFaceSmall entity, float partialTicks) {
        super.preRenderCallback(entity, partialTicks);
        this.glow.setAlpha(entity.getGlow(partialTicks));
        float scale = 0.8f + entity.getHalfMovementProgress(partialTicks) * entity.getHalfMovementProgress(partialTicks) * 0.2f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        int variant = entity.getVariant();
        if (variant == 0) {
            this.field_77045_g = this.model1;
            if (entity.isAnchored()) {
                GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)-0.25);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.45);
            }
        } else {
            this.field_77045_g = this.model2;
            if (entity.isAnchored()) {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.74);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntitySpiritTreeFaceSmall entity) {
        return TEXTURE;
    }
}

