/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.renderer.entity.RenderArrow;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.item.tools.bow.EnumArrowType;

@SideOnly(value=Side.CLIENT)
public class RenderBLArrow
extends RenderArrow<EntityBLArrow> {
    private static final ResourceLocation TEXTURE_ANGLER_TOOTH = new ResourceLocation("thebetweenlands:textures/entity/angler_tooth_arrow.png");
    private static final ResourceLocation TEXTURE_POISONED_ANGLER_TOOTH = new ResourceLocation("thebetweenlands:textures/entity/poisoned_angler_tooth_arrow.png");
    private static final ResourceLocation TEXTURE_OCTINE = new ResourceLocation("thebetweenlands:textures/entity/octine_arrow.png");
    private static final ResourceLocation TEXTURE_BASILISK = new ResourceLocation("thebetweenlands:textures/entity/basilisk_arrow.png");

    public RenderBLArrow(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityBLArrow entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.getArrowType() == EnumArrowType.OCTINE && ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            double rx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double ry = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double rz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(rx, ry, rz, 3.0f, 2.3f, 0.5f, 0.0f));
        }
        super.func_76986_a((EntityArrow)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityBLArrow entity) {
        switch (entity.getArrowType()) {
            case ANGLER_POISON: {
                return TEXTURE_POISONED_ANGLER_TOOTH;
            }
            case OCTINE: {
                return TEXTURE_OCTINE;
            }
            case BASILISK: {
                return TEXTURE_BASILISK;
            }
        }
        return TEXTURE_ANGLER_TOOTH;
    }
}

