/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.gui.GuiFirefly;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.Starfield;

public class GuiMainMenuBackground
extends GuiScreen {
    private List<List<GuiFirefly>> fireFlies;
    private ResourceLocation[] layerTextures;
    private int layerTick;
    private Random random = new Random();
    private Starfield starfieldEffect;
    private Framebuffer starfieldTextureFBO = null;

    public GuiMainMenuBackground(ResourceLocation texture, int layers) {
        this.layerTextures = new ResourceLocation[layers];
        for (int i = 0; i < layers; ++i) {
            this.layerTextures[i] = new ResourceLocation(texture.func_110624_b(), texture.func_110623_a() + "_" + i + ".png");
        }
    }

    public void func_73866_w_() {
        if (this.fireFlies == null) {
            this.fireFlies = new ArrayList<List<GuiFirefly>>();
            for (int i = 0; i < 3; ++i) {
                this.fireFlies.add(new ArrayList());
            }
        }
        this.delete();
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            this.starfieldTextureFBO = new Framebuffer(this.field_146294_l, this.field_146295_m, false);
            this.starfieldEffect = (Starfield)new Starfield(false).init();
            this.starfieldEffect.setTimeScale(5.0E-11f).setZoom(4.8f);
        }
    }

    public void func_146281_b() {
        this.delete();
    }

    public void func_73876_c() {
        ++this.layerTick;
        for (int i = 0; i < 3; ++i) {
            List<GuiFirefly> layer = this.fireFlies.get(i);
            Iterator<GuiFirefly> it = layer.iterator();
            while (it.hasNext()) {
                GuiFirefly firefly = it.next();
                if (firefly.getPosY() >= (float)(this.field_146294_l + 40) || firefly.getPosY() <= -40.0f || firefly.getPosX() <= -40.0f) {
                    it.remove();
                    continue;
                }
                firefly.update();
            }
            if (this.random.nextInt(32) != 0 || layer.size() >= 5) continue;
            layer.add(new GuiFirefly(this.field_146294_l + 50, this.random.nextInt(this.field_146295_m), -this.random.nextFloat() * 0.8f, (this.random.nextFloat() - this.random.nextFloat()) * 1.5f));
        }
    }

    public void delete() {
        if (this.starfieldTextureFBO != null) {
            this.starfieldTextureFBO.func_147608_a();
            this.starfieldTextureFBO = null;
        }
        if (this.starfieldEffect != null) {
            this.starfieldEffect.delete();
            this.starfieldEffect = null;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiMainMenuBackground.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16773120);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawStarfield(partialTicks);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (int i = 0; i < this.layerTextures.length; ++i) {
            if (i >= 1) {
                List<GuiFirefly> layer = this.fireFlies.get(i - 1);
                for (GuiFirefly firefly : layer) {
                    firefly.drawFireFly(this.field_146297_k, partialTicks);
                }
            }
            ResourceLocation layerTexture = this.layerTextures[i];
            this.field_146297_k.func_110434_K().func_110577_a(layerTexture);
            double u = (((float)this.layerTick + partialTicks) / (float)(this.layerTextures.length - i) / (float)(i + 1) + (float)(1024 * i) / 4.0f) / 4000.0f;
            double visibleU = (double)this.field_146294_l / (double)this.field_146295_m * (256.0 / (1024.0 * (double)i));
            double x = 0.0;
            double y = 0.0;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x + 0.0, y + (double)this.field_146295_m, (double)this.field_73735_i).func_187315_a(u, 1.0).func_181675_d();
            buffer.func_181662_b(x + (double)this.field_146294_l, y + (double)this.field_146295_m, (double)this.field_73735_i).func_187315_a(u + visibleU, 1.0).func_181675_d();
            buffer.func_181662_b(x + (double)this.field_146294_l, y + 0.0, (double)this.field_73735_i).func_187315_a(u + visibleU, 0.0).func_181675_d();
            buffer.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a(u, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179090_x();
        GuiMainMenuBackground.func_73734_a((int)0, (int)(this.field_146295_m - 30), (int)this.field_146294_l, (int)this.field_146295_m, (int)0x60000000);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawStarfield(float partialTicks) {
        if (ShaderHelper.INSTANCE.canUseShaders() && this.starfieldEffect != null && this.starfieldTextureFBO != null) {
            this.starfieldEffect.setOffset(((float)this.layerTick + partialTicks) / 8000.0f, 0.0f, 0.0f);
            int renderDimension = Math.max(this.field_146294_l, this.field_146295_m);
            this.starfieldEffect.create(this.starfieldTextureFBO).setPreviousFramebuffer(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(renderDimension, renderDimension).render(partialTicks);
            GlStateManager.func_179144_i((int)this.starfieldTextureFBO.field_147617_g);
            GL11.glBegin((int)4);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)0.0, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
        }
    }
}

