/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GuiFirefly
extends Gui {
    public static final ResourceLocation FIREFLY_TEXTURE = new ResourceLocation("thebetweenlands", "textures/gui/main/firefly.png");
    private float updateCounter = 0.0f;
    private float prevPosX = 0.0f;
    private float prevPosY = 0.0f;
    private float posX = 0.0f;
    private float posY = 0.0f;
    private float motionY = 0.0f;
    private float motionX = 0.0f;

    public GuiFirefly(float x, float y, float mX, float mY) {
        this.posX = this.prevPosX = x;
        this.posY = this.prevPosY = y;
        this.motionX = mX;
        this.motionY = mY;
    }

    public void update() {
        this.updateCounter += 1.0f;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.posX -= 0.4f;
        this.posY += this.motionY;
        this.posX += this.motionX;
        this.motionY = this.motionY > 0.0f ? (this.motionY -= 0.001f) : (this.motionY += 0.001f);
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public void drawFireFly(Minecraft minecraft, float partialTicks) {
        float interpX = this.prevPosX + (this.posX - this.prevPosX) * partialTicks;
        float interpY = this.prevPosY + (this.posY - this.prevPosY) * partialTicks;
        float interpUpdateCounter = (this.updateCounter + partialTicks) / 15.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        minecraft.func_110434_K().func_110577_a(FIREFLY_TEXTURE);
        GlStateManager.func_179109_b((float)(interpX + (float)(Math.sin(interpUpdateCounter) * 500.0) * 0.01f), (float)interpY, (float)0.0f);
        GlStateManager.func_179152_a((float)((0.1f + (float)(Math.sin(interpUpdateCounter) * Math.sin(interpUpdateCounter)) / 4.0f) * 0.1f), (float)((0.1f + (float)(Math.sin(interpUpdateCounter) * Math.sin(interpUpdateCounter)) / 4.0f) * 0.1f), (float)1.0f);
        this.drawTexturedModalRectWithColor(0, 0, 0, 0, 250, 250, -1277682);
        this.drawTexturedModalRectWithColor(0, 0, 0, 0, 250, 250, -1277682);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179121_F();
    }

    public void drawTexturedModalRectWithColor(int x, int y, int textureX, int textureY, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181666_a(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181666_a(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181666_a(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }
}

