/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.aspect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.AspectContainer;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.aspect.AspectManager;

public final class ItemAspectContainer
extends AspectContainer {
    public static final String ASPECTS_NBT_TAG = "blHerbloreAspects";
    public final ItemStack itemStack;
    @Nullable
    public final AspectManager manager;

    private ItemAspectContainer(AspectManager manager, ItemStack stack) {
        this.itemStack = stack;
        this.manager = manager;
    }

    public static ItemAspectContainer fromItem(ItemStack stack, @Nullable AspectManager manager) {
        NBTTagCompound aspectNbt;
        ItemAspectContainer container = new ItemAspectContainer(manager, stack);
        NBTTagCompound nBTTagCompound = aspectNbt = stack.func_77978_p() != null ? stack.func_77978_p().func_74775_l(ASPECTS_NBT_TAG) : null;
        if (aspectNbt != null) {
            container.read(aspectNbt);
        }
        return container;
    }

    public static ItemAspectContainer fromItem(ItemStack stack) {
        NBTTagCompound aspectNbt;
        ItemAspectContainer container = new ItemAspectContainer(null, stack);
        NBTTagCompound nBTTagCompound = aspectNbt = stack.func_77978_p() != null ? stack.func_77978_p().func_74775_l(ASPECTS_NBT_TAG) : null;
        if (aspectNbt != null) {
            container.read(aspectNbt);
        }
        return container;
    }

    @Override
    protected void onChanged() {
        NBTTagCompound nbt = this.itemStack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            this.itemStack.func_77982_d(nbt);
        }
        nbt.func_74782_a(ASPECTS_NBT_TAG, (NBTBase)this.save(new NBTTagCompound()));
    }

    public List<Aspect> getAspects(DiscoveryContainer<?> discoveries) {
        List<Aspect> discoveredAspects = null;
        if (discoveries != null && this.manager != null) {
            discoveredAspects = discoveries.getDiscoveredStaticAspects(this.manager, AspectManager.getAspectItem(this.itemStack));
        }
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        ImmutableSet<IAspectType> types = this.getStoredAspectTypes();
        for (IAspectType type : types) {
            int amount = this.get(type, true);
            boolean hasDiscovered = false;
            if (discoveredAspects != null) {
                for (Aspect discovered : discoveredAspects) {
                    if (discovered.type != type) continue;
                    hasDiscovered = true;
                    break;
                }
            }
            if (discoveredAspects == null || hasDiscovered) {
                amount += this.get(type, false);
            }
            if (amount <= 0) continue;
            aspects.add(new Aspect(type, amount));
        }
        return aspects;
    }

    public List<Aspect> getAspects(EntityPlayer player) {
        return this.getAspects(DiscoveryContainer.getMergedDiscoveryContainer(player));
    }

    @Override
    protected List<Aspect> getStaticAspects() {
        return this.manager != null ? this.manager.getStaticAspects(AspectManager.getAspectItem(this.itemStack)) : ImmutableList.of();
    }
}

