/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile;

import com.buuz135.industrial.item.addon.movility.TransferAddon;
import com.buuz135.industrial.jei.JEIHelper;
import com.buuz135.industrial.tile.api.IAcceptsTransferAddons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.ndrei.teslacorelib.compatibility.FontRendererUtil;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.SideDrawerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.tileentities.ElectricGenerator;
import org.jetbrains.annotations.NotNull;

public abstract class CustomGeneratorMachine
extends ElectricGenerator
implements IAcceptsTransferAddons {
    private int tick = 0;

    protected CustomGeneratorMachine(int typeId) {
        super(typeId);
    }

    protected void initializeInventories() {
        super.initializeInventories();
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
        facings.addAll(Arrays.asList(EnumFacing.values()));
        Arrays.stream(EnumDyeColor.values()).forEach(enumDyeColor -> this.getSideConfig().setSidesForColor(enumDyeColor, facings));
    }

    protected long getEnergyOutputRate() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(final BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        if (JEIHelper.isInstalled()) {
            pieces.add(new SideDrawerPiece(1){

                protected void renderState(BasicTeslaGuiContainer<?> basicTeslaGuiContainer, int i, BoundingRectangle boundingRectangle) {
                    container.bindDefaultTexture();
                    FontRendererUtil.INSTANCE.getFontRenderer().func_78276_b("J", boundingRectangle.getLeft() + 6, boundingRectangle.getTop() + 4, 4210751);
                }

                protected void clicked() {
                    JEIHelper.openBlockUses(new ItemStack(CustomGeneratorMachine.this.func_145838_q()));
                }
            });
        }
        return pieces;
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Tick", this.tick);
        return compound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tick = compound.func_74762_e("Tick");
    }

    public void protectedUpdate() {
        super.protectedUpdate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick % 10 == 0 && this.getAddonItems() != null) {
            this.workTransferAddon((TileEntity)this, this.getAddonItems());
        }
        ++this.tick;
        if (this.tick >= 20) {
            this.tick = 0;
        }
    }

    @Override
    public boolean canAcceptAddon(TransferAddon addon) {
        return !this.hasAddon(addon.getClass()) || this.getAddon(addon.getClass()) != null && ((TransferAddon)this.getAddon(addon.getClass())).getMode() != addon.getMode();
    }
}

