/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public class StorageTrackerItem
implements IStorageTracker<ItemStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private Map<ItemStack, IStorageTracker.IStorageTrackerEntry> changes = new TCustomHashMap((HashingStrategy)new HashingStrategy<ItemStack>(){

        public int computeHashCode(ItemStack stack) {
            return API.instance().getItemStackHashCode(stack);
        }

        public boolean equals(ItemStack left, ItemStack right) {
            return API.instance().getComparer().isEqualNoQuantity(left, right);
        }
    });
    private Runnable listener;

    public StorageTrackerItem(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(EntityPlayer player, ItemStack stack) {
        this.changes.put(stack, new StorageTrackerEntry(MinecraftServer.func_130071_aq(), player.func_70005_c_()));
        this.listener.run();
    }

    @Override
    public IStorageTracker.IStorageTrackerEntry get(ItemStack stack) {
        return this.changes.get(stack);
    }

    public void readFromNbt(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = StackUtils.deserializeStackFromNbt(tag.func_74775_l(NBT_STACK));
            if (stack.func_190926_b()) continue;
            this.changes.put(stack, new StorageTrackerEntry(tag.func_74763_f(NBT_TIME), tag.func_74779_i(NBT_NAME)));
        }
    }

    public NBTTagList serializeNbt() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ItemStack, IStorageTracker.IStorageTrackerEntry> entry : this.changes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(NBT_TIME, entry.getValue().getTime());
            tag.func_74778_a(NBT_NAME, entry.getValue().getName());
            tag.func_74782_a(NBT_STACK, (NBTBase)StackUtils.serializeStackToNbt(entry.getKey()));
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }
}

