/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.toolleveling;

import java.awt.Color;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.toolleveling.TinkerToolLeveling;
import slimeknights.toolleveling.ToolLevelNBT;
import slimeknights.toolleveling.config.Config;

public final class Tooltips {
    private Tooltips() {
    }

    public static void addTooltips(ItemStack itemStack, List<String> tooltips) {
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)itemStack, (String)TinkerToolLeveling.modToolLeveling.getModifierIdentifier());
        if (!tag.func_82582_d()) {
            ToolLevelNBT data = new ToolLevelNBT(tag);
            if (Config.canLevelUp(data.level)) {
                tooltips.add(1, Tooltips.getXpToolTip(data.xp, TinkerToolLeveling.modToolLeveling.getXpForLevelup(data.level, itemStack)));
            }
            tooltips.add(1, Tooltips.getLevelTooltip(data.level));
        }
    }

    private static String getXpToolTip(int xp, int xpNeeded) {
        return String.format("%s: %s", I18n.func_74838_a((String)"tooltip.xp"), Tooltips.getXpString(xp, xpNeeded));
    }

    private static String getXpString(int xp, int xpNeeded) {
        return TextFormatting.WHITE + String.format("%d / %d", xp, xpNeeded);
    }

    private static String getLevelTooltip(int level) {
        return String.format("%s: %s", I18n.func_74838_a((String)"tooltip.level"), Tooltips.getLevelString(level));
    }

    public static String getLevelString(int level) {
        return Tooltips.getLevelColor(level) + Tooltips.getRawLevelString(level) + TextFormatting.RESET;
    }

    private static String getRawLevelString(int level) {
        if (level <= 0) {
            return "";
        }
        if (I18n.func_94522_b((String)("tooltip.level." + level))) {
            return I18n.func_74838_a((String)("tooltip.level." + level));
        }
        int i = 1;
        while (I18n.func_94522_b((String)("tooltip.level." + i))) {
            ++i;
        }
        String str = I18n.func_74838_a((String)("tooltip.level." + level % i));
        for (int j = level / i; j > 0; --j) {
            str = str + '+';
        }
        return str;
    }

    private static String getLevelColor(int level) {
        float hue = 0.277777f * (float)level;
        hue -= (float)((int)hue);
        return CustomFontColor.encodeColor((int)Color.HSBtoRGB(hue, 0.75f, 0.8f));
    }
}

