/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostChunkGenerator;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostsouls.config.Config;
import mcjty.lostsouls.data.LostChunkData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class LostSoulData
extends WorldSavedData {
    public static final String NAME = "LostSoulData";
    private static LostSoulData instance = null;
    private final Map<ChunkCoord, LostChunkData> lostChunkDataMap = new HashMap<ChunkCoord, LostChunkData>();

    public LostSoulData(String name) {
        super(name);
    }

    public void save(World world) {
        world.func_72823_a(NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            LostSoulData.instance.lostChunkDataMap.clear();
            instance = null;
        }
    }

    @Nonnull
    public static LostSoulData getData(World world) {
        if (world.field_72995_K) {
            throw new RuntimeException("Don't access this client-side!");
        }
        if (instance != null) {
            return instance;
        }
        instance = (LostSoulData)world.func_72943_a(LostSoulData.class, NAME);
        if (instance == null) {
            instance = new LostSoulData(NAME);
        }
        return instance;
    }

    @Nonnull
    public static LostChunkData getSoulData(World world, int dimension, int chunkX, int chunkZ, @Nullable ILostChunkGenerator lost) {
        LostSoulData data = LostSoulData.getData(world);
        ChunkCoord cc = new ChunkCoord(dimension, chunkX, chunkZ);
        return data.getSoulData(world, cc, lost);
    }

    private LostChunkData getSoulData(World world, ChunkCoord cc, @Nullable ILostChunkGenerator lost) {
        if (!this.lostChunkDataMap.containsKey(cc)) {
            LostChunkData data = new LostChunkData(cc);
            if (lost == null) {
                data.initialize(cc, Config.HAUNTED_CHANCE, Config.MIN_MOBS, Config.MAX_MOBS);
            } else {
                ILostChunkInfo info = lost.getChunkInfo(cc.getChunkX(), cc.getChunkZ());
                if (info.getSphere() != null) {
                    data.initialize(cc, Config.SPHERE_HAUNTED_CHANCE, Config.SPHERE_MIN_MOBS, Config.SPHERE_MAX_MOBS);
                } else {
                    data.initialize(cc, Config.HAUNTED_CHANCE, Config.MIN_MOBS, Config.MAX_MOBS);
                }
            }
            this.lostChunkDataMap.put(cc, data);
            this.save(world);
        }
        return this.lostChunkDataMap.get(cc);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("chunks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = (NBTTagCompound)list.func_179238_g(i);
            int dim = tc.func_74762_e("dim");
            int x = tc.func_74762_e("x");
            int z = tc.func_74762_e("z");
            ChunkCoord cc = new ChunkCoord(dim, x, z);
            LostChunkData data = new LostChunkData(cc);
            data.readFromNBT(tc);
            this.lostChunkDataMap.put(cc, data);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkCoord, LostChunkData> entry : this.lostChunkDataMap.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("dim", entry.getKey().getDimension());
            tc.func_74768_a("x", entry.getKey().getChunkX());
            tc.func_74768_a("z", entry.getKey().getChunkZ());
            entry.getValue().writeToNBT(tc);
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("chunks", (NBTBase)list);
        return compound;
    }
}

