/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util.misc;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TextureSet {
    public static final TextureSet DEFAULT = TextureSet.of("all=blocks/planks_oak");
    public final ResourceLocation[] textures = new ResourceLocation[6];

    public static TextureSet of(String v) {
        TextureSet set = new TextureSet();
        Map<String, String> map = StringUtils.parse(StringUtils.TEMP_MAP, v);
        String s = map.get("all");
        if (s != null) {
            ResourceLocation tex = new ResourceLocation(s);
            for (int i = 0; i < 6; ++i) {
                set.textures[i] = tex;
            }
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            s = map.get(facing.func_176610_l());
            if (s == null) continue;
            set.textures[facing.ordinal()] = new ResourceLocation(s);
        }
        return set;
    }

    public static TextureSet of(JsonElement json) {
        return TextureSet.of(json.getAsString());
    }

    public static TextureSet of(IBlockState state) {
        return DEFAULT;
    }

    private TextureSet() {
    }

    @Nullable
    public ResourceLocation getTexture(EnumFacing face) {
        return this.textures[face.ordinal()];
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < 6; ++i) {
            if (this.textures[i] == null) continue;
            list.add(this.textures[i]);
        }
        return list;
    }
}

