/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.server.command.TextComponentHelper;

public class SidedUtils {
    private static final Map<String, String> SERVER_MODS_0 = new HashMap<String, String>();
    public static final Map<String, String> SERVER_MODS = Collections.unmodifiableMap(SERVER_MODS_0);
    public static UUID UNIVERSE_UUID_CLIENT = null;

    public static ITextComponent lang(@Nullable ICommandSender sender, String mod, String key, Object ... args) {
        return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)key, (Object[])args);
    }

    public static void checkModLists(@Nullable Side side, @Nullable Map<String, String> map) {
        if (side == Side.SERVER) {
            SERVER_MODS_0.clear();
            if (map != null && !map.isEmpty()) {
                SERVER_MODS_0.putAll(map);
            }
        } else if (side == Side.CLIENT) {
            // empty if block
        }
    }

    public static boolean isModLoadedOnServer(String modid) {
        return !modid.isEmpty() && SERVER_MODS_0.containsKey(modid);
    }

    public static boolean areAllModsLoadedOnServer(Collection<String> modids) {
        if (!modids.isEmpty()) {
            for (String modid : modids) {
                if (SidedUtils.isModLoadedOnServer(modid)) continue;
                return false;
            }
        }
        return true;
    }
}

