/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.network.packet.SetSlotLarge;
import org.cyclops.colossalchests.network.packet.WindowItemsFragmentPacket;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;

@ChestContainer(isLargeChest=true)
public class ContainerColossalChest
extends ScrollingInventoryContainer<Slot> {
    private static final int INVENTORY_OFFSET_X = 9;
    private static final int INVENTORY_OFFSET_Y = 112;
    private static final int CHEST_INVENTORY_OFFSET_X = 9;
    private static final int CHEST_INVENTORY_OFFSET_Y = 18;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    private final TileColossalChest tile;
    private final List<Slot> chestSlots;
    private int lastInventoryHash = -2;
    private boolean firstDetectionCheck = true;

    public ContainerColossalChest(InventoryPlayer inventory, TileColossalChest tile) {
        super(inventory, (IGuiContainerProvider)ColossalChest.getInstance(), Collections.emptyList(), (ScrollingInventoryContainer.IItemPredicate)new ScrollingInventoryContainer.IItemPredicate<Slot>(){

            public boolean apply(Slot item, Pattern pattern) {
                return true;
            }
        });
        this.tile = tile;
        tile.func_174889_b(inventory.field_70458_d);
        this.chestSlots = Lists.newArrayListWithCapacity((int)tile.func_70302_i_());
        this.addChestSlots(tile.func_70302_i_() / 9, 9);
        this.addPlayerInventory(inventory, 9, 112);
        this.updateFilter("");
        if (tile.func_145831_w().field_72995_K) {
            tile.getInventory().func_174888_l();
        }
    }

    protected List<Slot> getUnfilteredItems() {
        return this.chestSlots;
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = this.makeSlot((IInventory)this.tile, column + row * columns, 9 + column * 18, 18 + row * 18);
                this.func_75146_a(slot);
                this.chestSlots.add(slot);
            }
        }
    }

    protected Slot makeSlot(IInventory inventory, int index, int row, int column) {
        return new SlotExtended(inventory, index, row, column);
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        super.func_75134_a(entityplayer);
        this.tile.func_174886_c(entityplayer);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.canInteractWith(playerIn);
    }

    protected int getSizeInventory() {
        return this.tile.func_70302_i_();
    }

    public int getColumns() {
        return 9;
    }

    public int getPageSize() {
        return 5;
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = Integer.MIN_VALUE;
        slot.field_75221_f = Integer.MIN_VALUE;
    }

    protected void enableSlot(int slotIndex, int row, int column) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = 9 + column * 18;
        slot.field_75221_f = 18 + row * 18;
    }

    protected void onScroll() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
    }

    protected void enableElementAt(int visibleIndex, int elementIndex, Slot element) {
        super.enableElementAt(visibleIndex, elementIndex, (Object)element);
        int column = visibleIndex % this.getColumns();
        int row = (visibleIndex - column) / this.getColumns();
        this.enableSlot(elementIndex, row, column);
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        if (listener instanceof EntityPlayerMP) {
            this.updateCraftingInventory((EntityPlayerMP)listener, (List<ItemStack>)this.func_75138_a());
        } else {
            listener.func_71110_a((Container)this, this.func_75138_a());
        }
        this.func_75142_b();
    }

    public void func_75142_b() {
        int newHash = this.tile.getInventoryHash();
        if (this.lastInventoryHash != newHash) {
            this.lastInventoryHash = newHash;
            this.detectAndSendChangesOverride();
        }
    }

    protected void detectAndSendChangesOverride() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemstack1);
            if (this.firstDetectionCheck) continue;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                IContainerListener listener = (IContainerListener)this.field_75149_d.get(j);
                if (listener instanceof EntityPlayerMP) {
                    this.sendSlotContentsToPlayer((EntityPlayerMP)listener, (Container)this, i, itemstack1);
                    continue;
                }
                listener.func_71111_a((Container)this, i, itemstack1);
            }
        }
        this.firstDetectionCheck = false;
    }

    protected void sendSlotContentsToPlayer(EntityPlayerMP player, Container containerToSend, int slotInd, ItemStack stack) {
        if (!(containerToSend.func_75139_a(slotInd) instanceof SlotCrafting) && !player.field_71137_h) {
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new SetSlotLarge(containerToSend.field_75152_c, slotInd, stack), player);
        }
    }

    protected int getTagSize(NBTBase tag) {
        if (tag instanceof NBTPrimitive || tag instanceof NBTTagEnd) {
            return 1;
        }
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)tag;
            int size = 0;
            for (String key : compound.func_150296_c()) {
                size += this.getTagSize(compound.func_74781_a(key));
            }
            return size;
        }
        if (tag instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)tag).func_150292_c().length;
        }
        if (tag instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)tag).func_150302_c().length * 32;
        }
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            int size = 0;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                size += this.getTagSize(list.func_179238_g(i));
            }
            return size;
        }
        if (tag instanceof NBTTagString) {
            try {
                return ((NBTTagString)tag).func_150285_a_().getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return tag.toString().length();
    }

    public void updateCraftingInventory(EntityPlayerMP player, List<ItemStack> allItems) {
        int maxBufferSize = GeneralConfig.maxPacketBufferSize;
        NetHandlerPlayServer playerNetServerHandler = player.field_71135_a;
        NBTTagCompound sendBuffer = new NBTTagCompound();
        NBTTagList sendList = new NBTTagList();
        sendBuffer.func_74782_a("stacks", (NBTBase)sendList);
        int i = 0;
        int bufferSize = 0;
        boolean sent = false;
        for (ItemStack itemStack : allItems) {
            if (itemStack != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("slot", i);
                tag.func_74782_a("stack", (NBTBase)itemStack.serializeNBT());
                int tagSize = this.getTagSize((NBTBase)tag);
                if (bufferSize + tagSize + 100 < maxBufferSize) {
                    sendList.func_74742_a((NBTBase)tag);
                    bufferSize += tagSize;
                } else {
                    ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new WindowItemsFragmentPacket(this.field_75152_c, sendBuffer), player);
                    sendBuffer = new NBTTagCompound();
                    sendList = new NBTTagList();
                    sendList.func_74742_a((NBTBase)tag);
                    sendBuffer.func_74782_a("stacks", (NBTBase)sendList);
                    bufferSize = tagSize;
                }
            }
            ++i;
        }
        if (sendList.func_74745_c() > 0) {
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new WindowItemsFragmentPacket(this.field_75152_c, sendBuffer), player);
        }
        playerNetServerHandler.func_147359_a((Packet)new SPacketSetSlot(-1, -1, player.field_71071_by.func_70445_o()));
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSelection() {
        try {
            int i;
            HashMap selection = Maps.newHashMap();
            ArrayList chest = Lists.newArrayList();
            ArrayList playerInventory = Lists.newArrayList();
            for (i = 0; i < this.getSizeInventory(); ++i) {
                chest.add(this.func_75139_a(i));
            }
            for (i = this.getSizeInventory(); i < this.getSizeInventory() + this.player.field_71071_by.field_70462_a.size(); ++i) {
                playerInventory.add(this.func_75139_a(i));
            }
            selection.put(ContainerSection.CHEST, chest);
            selection.put(ContainerSection.INVENTORY, playerInventory);
            return selection;
        }
        catch (RuntimeException e) {
            System.out.println("Size inv " + this.getSizeInventory());
            System.out.println("Player size inv " + this.player.field_71071_by.field_70462_a.size());
            System.out.println("Available slots " + this.field_75151_b.size());
            throw e;
        }
    }
}

