/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawerKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemQuantifyKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemShroudKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemTape;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeCreative;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_template")
    public static Item upgradeTemplate;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_storage")
    public static ItemUpgradeStorage upgradeStorage;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_one_stack")
    public static ItemUpgrade upgradeOneStack;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_status")
    public static ItemUpgradeStatus upgradeStatus;
    @GameRegistry.ObjectHolder(value="storagedrawers:drawer_key")
    public static ItemDrawerKey drawerKey;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_void")
    public static ItemUpgrade upgradeVoid;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_conversion")
    public static ItemUpgrade upgradeConversion;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_creative")
    public static ItemUpgradeCreative upgradeCreative;
    @GameRegistry.ObjectHolder(value="storagedrawers:upgrade_redstone")
    public static ItemUpgradeRedstone upgradeRedstone;
    @GameRegistry.ObjectHolder(value="storagedrawers:shroud_key")
    public static ItemShroudKey shroudKey;
    @GameRegistry.ObjectHolder(value="storagedrawers:personal_key")
    public static ItemPersonalKey personalKey;
    @GameRegistry.ObjectHolder(value="storagedrawers:quantify_key")
    public static ItemQuantifyKey quantifyKey;
    @GameRegistry.ObjectHolder(value="storagedrawers:tape")
    public static ItemTape tape;

    public static String makeName(String name) {
        return "storagedrawers".toLowerCase() + "." + name;
    }

    @Mod.EventBusSubscriber(modid="storagedrawers")
    public static class Registration {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry itemRegistry = event.getRegistry();
            ConfigManager config = StorageDrawers.config;
            itemRegistry.register((IForgeRegistryEntry)((Item)new Item().func_77655_b(ModItems.makeName("upgradeTemplate")).setRegistryName("upgrade_template")).func_77637_a(ModCreativeTabs.tabStorageDrawers));
            if (config.cache.enableStorageUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgradeStorage("upgrade_storage", ModItems.makeName("upgradeStorage")));
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgrade("upgrade_one_stack", ModItems.makeName("upgradeOneStack")));
            }
            if (StorageDrawers.config.cache.enableIndicatorUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgradeStatus("upgrade_status", ModItems.makeName("upgradeStatus")));
            }
            if (StorageDrawers.config.cache.enableVoidUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgrade("upgrade_void", ModItems.makeName("upgradeVoid")));
            }
            if (StorageDrawers.config.cache.enableItemConversion) {
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgrade("upgrade_conversion", ModItems.makeName("upgradeConversion")));
            }
            if (StorageDrawers.config.cache.enableCreativeUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgradeCreative("upgrade_creative", ModItems.makeName("upgradeCreative")));
            }
            if (StorageDrawers.config.cache.enableRedstoneUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemUpgradeRedstone("upgrade_redstone", ModItems.makeName("upgradeRedstone")));
            }
            if (StorageDrawers.config.cache.enableLockUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemDrawerKey("drawer_key", ModItems.makeName("drawerKey")));
            }
            if (StorageDrawers.config.cache.enableShroudUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemShroudKey("shroud_key", ModItems.makeName("shroudKey")));
            }
            if (StorageDrawers.config.cache.enablePersonalUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemPersonalKey("personal_key", ModItems.makeName("personalKey")));
            }
            if (StorageDrawers.config.cache.enableQuantifiableUpgrades) {
                itemRegistry.register((IForgeRegistryEntry)new ItemQuantifyKey("quantify_key", ModItems.makeName("quantifyKey")));
            }
            if (StorageDrawers.config.cache.enableTape) {
                itemRegistry.register((IForgeRegistryEntry)new ItemTape("tape", ModItems.makeName("tape")));
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
            modelRegistry.registerItemVariants(upgradeTemplate);
            modelRegistry.registerItemVariants((Item)upgradeVoid);
            modelRegistry.registerItemVariants((Item)upgradeConversion);
            modelRegistry.registerItemVariants((Item)tape);
            modelRegistry.registerItemVariants((Item)drawerKey);
            modelRegistry.registerItemVariants((Item)shroudKey);
            modelRegistry.registerItemVariants((Item)personalKey);
            modelRegistry.registerItemVariants((Item)quantifyKey);
            modelRegistry.registerItemVariants((Item)upgradeStorage);
            modelRegistry.registerItemVariants((Item)upgradeOneStack);
            modelRegistry.registerItemVariants((Item)upgradeStatus);
            modelRegistry.registerItemVariants((Item)upgradeCreative);
            modelRegistry.registerItemVariants((Item)upgradeRedstone);
        }
    }
}

