/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.block;

import WayofTime.bloodmagic.block.BlockBloodTank;
import WayofTime.bloodmagic.tile.TileBloodTank;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockBloodTank
extends ItemBlock {
    public ItemBlockBloodTank(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
        if (fluidStack != null) {
            return super.func_77653_i(stack) + " " + TextHelper.localizeEffect("tooltip.bloodmagic.tier", stack.func_77952_i() + 1) + " (" + fluidStack.getLocalizedName() + ")";
        }
        return super.func_77653_i(stack) + " " + TextHelper.localizeEffect("tooltip.bloodmagic.tier", stack.func_77952_i() + 1);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        FluidStack fluidStack;
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.tier", stack.func_77952_i() + 1));
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.fluid.capacity", this.getCapacity(stack)));
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"))) != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.fluid.type", fluidStack.getLocalizedName()));
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.fluid.amount", fluidStack.amount, this.getCapacity(stack)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < TileBloodTank.CAPACITIES.length; ++i) {
            list.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public int getCapacity(ItemStack container) {
        int meta = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(TileBloodTank.CAPACITIES.length - 1));
        return !container.func_190926_b() && Block.func_149634_a((Item)container.func_77973_b()) instanceof BlockBloodTank ? TileBloodTank.CAPACITIES[meta] * 1000 : 0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, this.getCapacity(stack));
    }
}

