/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.internal.inventory.ItemSorption;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class InventoryConnection {
    private List<ItemSorption> sorptionList;

    public InventoryConnection(List<ItemSorption> sorptionList) {
        this.sorptionList = new ArrayList<ItemSorption>(sorptionList);
    }

    public InventoryConnection copy() {
        return new InventoryConnection(this.sorptionList);
    }

    public ItemSorption getItemSorption(int tankNumber) {
        return this.sorptionList.get(tankNumber);
    }

    public void setItemSorption(int tankNumber, ItemSorption sorption) {
        this.sorptionList.set(tankNumber, sorption);
    }

    public boolean canConnect() {
        for (ItemSorption sorption : this.sorptionList) {
            if (!sorption.canConnect()) continue;
            return true;
        }
        return false;
    }

    public void toggleItemSorption(int tankNumber) {
        this.setItemSorption(tankNumber, this.getItemSorption(tankNumber).next());
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        NBTTagCompound connectionTag = new NBTTagCompound();
        for (int i = 0; i < this.sorptionList.size(); ++i) {
            connectionTag.func_74768_a("sorption" + i, this.getItemSorption(i).ordinal());
        }
        nbt.func_74782_a("fluidConnection" + side.func_176745_a(), (NBTBase)connectionTag);
        return nbt;
    }

    public final InventoryConnection readFromNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        if (nbt.func_74764_b("fluidConnection" + side.func_176745_a())) {
            NBTTagCompound connectionTag = nbt.func_74775_l("fluidConnection" + side.func_176745_a());
            for (int i = 0; i < this.sorptionList.size(); ++i) {
                if (!connectionTag.func_74764_b("sorption" + i)) continue;
                this.setItemSorption(i, ItemSorption.values()[connectionTag.func_74762_e("sorption" + i)]);
            }
        }
        return this;
    }
}

