/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.internal.fluid.TankSorption;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class FluidConnection {
    @Nonnull
    private List<TankSorption> sorptionList;

    public FluidConnection(@Nonnull List<TankSorption> sorptionList) {
        this.sorptionList = new ArrayList<TankSorption>(sorptionList);
    }

    public FluidConnection copy() {
        return new FluidConnection(this.sorptionList);
    }

    public TankSorption getTankSorption(int tankNumber) {
        return this.sorptionList.get(tankNumber);
    }

    public void setTankSorption(int tankNumber, TankSorption sorption) {
        this.sorptionList.set(tankNumber, sorption);
    }

    public boolean canConnect() {
        for (TankSorption sorption : this.sorptionList) {
            if (!sorption.canConnect()) continue;
            return true;
        }
        return false;
    }

    public void toggleTankSorption(int tankNumber) {
        this.setTankSorption(tankNumber, this.getTankSorption(tankNumber).next());
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        NBTTagCompound connectionTag = new NBTTagCompound();
        for (int i = 0; i < this.sorptionList.size(); ++i) {
            connectionTag.func_74768_a("sorption" + i, this.getTankSorption(i).ordinal());
        }
        nbt.func_74782_a("fluidConnection" + side.func_176745_a(), (NBTBase)connectionTag);
        return nbt;
    }

    public final FluidConnection readFromNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        if (nbt.func_74764_b("fluidConnection" + side.func_176745_a())) {
            NBTTagCompound connectionTag = nbt.func_74775_l("fluidConnection" + side.func_176745_a());
            for (int i = 0; i < this.sorptionList.size(); ++i) {
                if (!connectionTag.func_74764_b("sorption" + i)) continue;
                this.setTankSorption(i, TankSorption.values()[connectionTag.func_74762_e("sorption" + i)]);
            }
        }
        return this;
    }
}

