/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import nc.radiation.RadSources;
import nc.recipe.ProcessorRecipeHandler;

public class DecayHastenerRecipes
extends ProcessorRecipeHandler {
    public DecayHastenerRecipes() {
        super("decay_hastener", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addDecayRecipes("Thorium230Base", "dustLead");
        this.addDecayRecipes("Thorium232", "dustLead");
        this.addDecayRecipes("Uranium233", "dustLead");
        this.addDecayRecipes("Uranium235", "dustLead");
        this.addDecayRecipes("Uranium238Base", "Thorium230Base");
        this.addDecayRecipes("Neptunium236", "Thorium232");
        this.addDecayRecipes("Neptunium237Base", "Uranium233");
        this.addDecayRecipes("Plutonium238Base", "Thorium230Base");
        this.addDecayRecipes("Plutonium239", "Uranium235");
        this.addDecayRecipes("Plutonium241", "Neptunium237Base");
        this.addDecayRecipes("Plutonium242Base", "Uranium238Base");
        this.addDecayRecipes("Americium241Base", "Neptunium237Base");
        this.addDecayRecipes("Americium242", "Thorium230Base");
        this.addDecayRecipes("Americium243Base", "Plutonium239");
        this.addDecayRecipes("Curium243", "Plutonium239");
        this.addDecayRecipes("Curium245", "Plutonium241");
        this.addDecayRecipes("Curium246Base", "Plutonium242Base");
        this.addDecayRecipes("Curium247", "Americium243Base");
        this.addDecayRecipes("Berkelium247Base", "Americium243Base");
        this.addDecayRecipes("Berkelium248", "Thorium232");
        this.addDecayRecipes("Californium249", "Curium245");
        this.addDecayRecipes("Californium250Base", "Curium246Base");
        this.addDecayRecipes("Californium251", "Curium247");
        this.addDecayRecipes("Californium252Base", "Thorium232");
    }

    public void addDecayRecipes(String input, String output) {
        boolean isInputBase = input.substring(input.length() - 4, input.length()).equals("Base");
        boolean isOutputBase = output.substring(output.length() - 4, output.length()).equals("Base");
        boolean isLead = output.equals("dustLead");
        for (String size : new String[]{"ingot", "nugget"}) {
            for (String oxide : new String[]{"", "Oxide"}) {
                String inputName = size + (oxide.equals("Oxide") && isInputBase || size.equals("nugget") && isInputBase ? input.substring(0, input.length() - 4) : input) + oxide;
                Double radiation = RadSources.ORE_MAP.get(inputName);
                double radiationLevel = radiation == null ? 0.0 : radiation;
                Object[] objectArray = new Object[5];
                objectArray[0] = inputName;
                objectArray[1] = isLead ? (size.equals("ingot") ? "dustLead" : "tinyDustLead") : size + (oxide.equals("Oxide") && isOutputBase || size.equals("nugget") && isOutputBase ? output.substring(0, output.length() - 4) : output) + oxide;
                objectArray[2] = size.equals("nugget") ? 0.1111111111111111 : 1.0;
                objectArray[3] = 1.0;
                objectArray[4] = radiationLevel / 8.0;
                this.addRecipe(objectArray);
            }
        }
    }
}

