/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import nc.recipe.ProcessorRecipeHandler;

public class CentrifugeRecipes
extends ProcessorRecipeHandler {
    public CentrifugeRecipes() {
        super("centrifuge", 0, 1, 0, 4);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(this.fluidStack("boron", 144), this.fluidStack("boron11", 144), this.fluidStack("boron10", 48), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("lithium", 144), this.fluidStack("lithium7", 144), this.fluidStack("lithium6", 48), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addCoolantNAKRecipe("redstone", 1000);
        this.addCoolantNAKRecipe("quartz", 4662);
        this.addCoolantNAKRecipe("gold", 576);
        this.addCoolantNAKRecipe("glowstone", 1750);
        this.addCoolantNAKRecipe("lapis", 5994);
        this.addCoolantNAKRecipe("diamond", 2664);
        this.addCoolantNAKRecipe("liquidhelium", 500);
        this.addCoolantNAKRecipe("ender", 1000);
        this.addCoolantNAKRecipe("cryotheum", 1000);
        this.addCoolantNAKRecipe("iron", 576);
        this.addCoolantNAKRecipe("emerald", 1998);
        this.addCoolantNAKRecipe("copper", 576);
        this.addCoolantNAKRecipe("tin", 576);
        this.addCoolantNAKRecipe("magnesium", 576);
        this.addFuelIsotopeRecipes("eu", "uranium", 238, 233, 235);
        this.addFuelIsotopeRecipes("en", "neptunium", 237, 236);
        this.addFuelIsotopeRecipes("ep", "plutonium", 242, 239, 241);
        this.addFuelIsotopeRecipes("ea", "americium", 243, 242);
        this.addFuelIsotopeRecipes("ecm", "curium", 246, 243, 245, 247);
        this.addFuelIsotopeRecipes("eb", "berkelium", 247, 248);
        this.addFuelIsotopeRecipes("ecf", "californium", 252, 249, 251);
        this.addRecipe(this.fluidStack("thorium", 144), this.fluidStack("fuel_tbu", 144), this.fluidStack("thorium_230", 16), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("thorium_fluoride", 144), this.fluidStack("fuel_tbu_fluoride", 144), this.fluidStack("thorium_230_fluoride", 16), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("thorium_fluoride_flibe", 144), this.fluidStack("fuel_tbu_fluoride_flibe", 144), this.fluidStack("thorium_230_fluoride_flibe", 16), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addIsotopeMixRecipes("uranium", 238, 235);
        this.addIsotopeMixRecipes("plutonium", 239, 242);
        this.addIsotopeFLIBERecipes("thorium", 230);
        this.addIsotopeFLIBERecipes("uranium", 233, 235, 238);
        this.addIsotopeFLIBERecipes("neptunium", 236, 237);
        this.addIsotopeFLIBERecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeFLIBERecipes("americium", 241, 242, 243);
        this.addIsotopeFLIBERecipes("curium", 243, 245, 246, 247);
        this.addIsotopeFLIBERecipes("berkelium", 247, 248);
        this.addIsotopeFLIBERecipes("californium", 249, 250, 251, 252);
        this.addRecipe(this.fluidStack("fuel_tbu_fluoride_flibe", 288), this.fluidStack("fuel_tbu_fluoride", 144), this.fluidStack("flibe", 144), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("depleted_fuel_tbu_fluoride_flibe", 288), this.fluidStack("depleted_fuel_tbu_fluoride", 144), this.fluidStack("flibe", 144), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        this.addFissionFuelFLIBERecipes("eu", 233, 235);
        this.addFissionFuelFLIBERecipes("en", 236);
        this.addFissionFuelFLIBERecipes("ep", 239, 241);
        this.addFissionFuelFLIBERecipes("ea", 242);
        this.addFissionFuelFLIBERecipes("ecm", 243, 245, 247);
        this.addFissionFuelFLIBERecipes("eb", 248);
        this.addFissionFuelFLIBERecipes("ecf", 249, 251);
        this.addReprocessingRecipes("tbu", "uranium_233", 4, "uranium_235", 2, "neptunium_236", 2, "neptunium_237", 8);
        this.addReprocessingRecipes("leu_235", "uranium_238", 10, "neptunium_237", 2, "plutonium_239", 2, "plutonium_241", 2);
        this.addReprocessingRecipes("heu_235", "uranium_238", 5, "neptunium_237", 4, "plutonium_239", 1, "plutonium_242", 6);
        this.addReprocessingRecipes("leu_233", "plutonium_239", 1, "plutonium_241", 1, "plutonium_242", 8, "americium_243", 6);
        this.addReprocessingRecipes("heu_233", "neptunium_236", 8, "neptunium_237", 2, "plutonium_242", 4, "americium_243", 2);
        this.addReprocessingRecipes("len_236", "neptunium_237", 1, "plutonium_242", 8, "americium_242", 2, "americium_243", 5);
        this.addReprocessingRecipes("hen_236", "uranium_238", 4, "plutonium_238", 2, "plutonium_239", 2, "plutonium_242", 8);
        this.addReprocessingRecipes("lep_239", "plutonium_239", 2, "plutonium_242", 6, "curium_243", 1, "curium_246", 7);
        this.addReprocessingRecipes("hep_239", "americium_241", 2, "americium_242", 6, "curium_245", 2, "curium_246", 6);
        this.addReprocessingRecipes("lep_241", "plutonium_242", 1, "americium_242", 1, "americium_243", 2, "curium_246", 12);
        this.addReprocessingRecipes("hep_241", "americium_241", 2, "curium_245", 2, "curium_246", 6, "curium_247", 6);
        this.addReprocessingRecipes("lea_242", "curium_243", 2, "curium_245", 2, "curium_246", 10, "curium_247", 2);
        this.addReprocessingRecipes("hea_242", "curium_245", 4, "curium_246", 8, "curium_247", 2, "berkelium_247", 2);
        this.addReprocessingRecipes("lecm_243", "curium_246", 8, "berkelium_247", 4, "berkelium_248", 2, "californium_249", 2);
        this.addReprocessingRecipes("hecm_243", "curium_246", 6, "berkelium_247", 6, "berkelium_248", 2, "californium_249", 2);
        this.addReprocessingRecipes("lecm_245", "berkelium_247", 10, "berkelium_248", 2, "californium_249", 1, "californium_252", 3);
        this.addReprocessingRecipes("hecm_245", "berkelium_247", 12, "berkelium_248", 1, "californium_249", 1, "californium_251", 2);
        this.addReprocessingRecipes("lecm_247", "berkelium_247", 5, "berkelium_248", 1, "californium_251", 2, "californium_252", 8);
        this.addReprocessingRecipes("hecm_247", "berkelium_248", 2, "californium_249", 2, "californium_251", 6, "californium_252", 6);
        this.addReprocessingRecipes("leb_248", "californium_249", 1, "californium_251", 1, "californium_252", 7, "californium_252", 7);
        this.addReprocessingRecipes("heb_248", "californium_250", 2, "californium_251", 2, "californium_252", 6, "californium_252", 6);
        this.addReprocessingRecipes("lecf_249", "californium_250", 4, "californium_251", 2, "californium_252", 5, "californium_252", 5);
        this.addReprocessingRecipes("hecf_249", "californium_250", 8, "californium_251", 4, "californium_252", 2, "californium_252", 2);
        this.addReprocessingRecipes("lecf_251", "californium_251", 1, "californium_252", 5, "californium_252", 5, "californium_252", 5);
        this.addReprocessingRecipes("hecf_251", "californium_251", 4, "californium_252", 4, "californium_252", 4, "californium_252", 4);
    }

    public void addCoolantNAKRecipe(String name, int amount) {
        this.addRecipe(this.fluidStack(name + "_nak", 576), this.fluidStack(name, amount), this.fluidStack("nak", 576), this.emptyFluidStack(), this.emptyFluidStack(), 2.0, 1.0);
    }

    public void addFuelIsotopeRecipes(String suffix, String element, int fertile, int ... fissiles) {
        for (String type : new String[]{"", "_fluoride"}) {
            for (int fissile : fissiles) {
                this.addRecipe(this.fluidStack("fuel_l" + suffix + "_" + fissile + type, 144), this.fluidStack(element + "_" + fertile + type, 128), this.fluidStack(element + "_" + fissile + type, 16), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
                this.addRecipe(this.fluidStack("fuel_h" + suffix + "_" + fissile + type, 144), this.fluidStack(element + "_" + fertile + type, 80), this.fluidStack(element + "_" + fissile + type, 64), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
            }
        }
    }

    public void addElementFLIBERecipes(String ... elements) {
        for (String element : elements) {
            this.addRecipe(this.fluidStack(element + "_fluoride_flibe", 288), this.fluidStack(element + "_fluoride", 144), this.fluidStack("flibe", 144), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        }
    }

    public void addIsotopeMixRecipes(String element, int major, int minor) {
        for (String type : new String[]{"", "_fluoride", "_fluoride_flibe"}) {
            this.addRecipe(this.fluidStack(element + type, 144), this.fluidStack(element + "_" + major + type, 144), this.fluidStack(element + "_" + minor + type, 16), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        }
    }

    public void addIsotopeFLIBERecipes(String element, int ... types) {
        for (int type : types) {
            this.addRecipe(this.fluidStack(element + "_" + type + "_fluoride_flibe", 288), this.fluidStack(element + "_" + type + "_fluoride", 144), this.fluidStack("flibe", 144), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
        }
    }

    public void addFissionFuelFLIBERecipes(String suffix, int ... types) {
        for (int type : types) {
            for (String form : new String[]{"fuel_l", "fuel_h", "depleted_fuel_l", "depleted_fuel_h"}) {
                this.addRecipe(this.fluidStack(form + suffix + "_" + type + "_fluoride_flibe", 288), this.fluidStack(form + suffix + "_" + type + "_fluoride", 144), this.fluidStack("flibe", 144), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 1.0);
            }
        }
    }

    public void addReprocessingRecipes(String fuel, String out1, int n1, String out2, int n2, String out3, int n3, String out4, int n4) {
        for (String type : new String[]{""}) {
            this.addRecipe(this.fluidStack("depleted_fuel_" + fuel + type, 324), this.fluidStack(out1 + type, 16 * n1), this.fluidStack(out2 + type, 16 * n2), this.fluidStack(out3 + type, 16 * n3), this.fluidStack(out4 + type, 16 * n4), 0.5, 0.5);
        }
    }
}

