/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import nc.util.NCMath;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class ChanceFluidIngredient
implements IFluidIngredient {
    public IFluidIngredient ingredient;
    public int chancePercent;
    public int stackDiff;
    public int minStackSize;
    public int sizeIncrSteps;
    public double meanStackSize;

    public ChanceFluidIngredient(IFluidIngredient ingredient, int chancePercent, int stackDiff) {
        this(ingredient, chancePercent, stackDiff, 0);
    }

    public ChanceFluidIngredient(IFluidIngredient ingredient, int chancePercent, int stackDiff, int minStackSize) {
        this.ingredient = ingredient;
        this.chancePercent = MathHelper.func_76125_a((int)chancePercent, (int)0, (int)100);
        this.stackDiff = Math.max(1, stackDiff);
        this.minStackSize = MathHelper.func_76125_a((int)minStackSize, (int)0, (int)ingredient.getMaxStackSize());
        int sizeIncrSteps = (ingredient.getMaxStackSize() - this.minStackSize) / this.stackDiff;
        int sizeShift = ingredient.getMaxStackSize() - this.minStackSize - sizeIncrSteps * this.stackDiff;
        this.ingredient.setMaxStackSize(this.ingredient.getMaxStackSize() + sizeShift);
        this.minStackSize += sizeShift;
        this.sizeIncrSteps = sizeIncrSteps;
        this.meanStackSize = (double)this.minStackSize + (double)(this.ingredient.getMaxStackSize() - this.minStackSize) * (double)this.chancePercent / 100.0;
    }

    @Override
    public FluidStack getStack() {
        return this.ingredient.getStack();
    }

    @Override
    public String getIngredientName() {
        return this.ingredient.getIngredientName() + " [ " + this.chancePercent + "%, diff: " + this.stackDiff + ", min: " + this.minStackSize + " ]";
    }

    @Override
    public String getIngredientNamesConcat() {
        return this.ingredient.getIngredientNamesConcat() + " [ " + this.chancePercent + "%, diff: " + this.stackDiff + ", min: " + this.minStackSize + " ]";
    }

    @Override
    public int getMaxStackSize() {
        return this.ingredient.getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.ingredient.setMaxStackSize(stackSize);
    }

    @Override
    public int getNextStackSize() {
        return this.minStackSize + this.stackDiff * NCMath.getBinomial(this.sizeIncrSteps, this.chancePercent);
    }

    @Override
    public List<FluidStack> getInputStackList() {
        ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
        for (FluidStack stack : this.ingredient.getInputStackList()) {
            for (int runningStackSize = this.minStackSize; runningStackSize <= this.getMaxStackSize(); runningStackSize += this.stackDiff) {
                FluidStack newStack = stack.copy();
                newStack.amount = runningStackSize;
                stackList.add(newStack);
            }
        }
        return stackList;
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
        for (int runningStackSize = this.minStackSize; runningStackSize <= this.getMaxStackSize(); runningStackSize += this.stackDiff) {
            FluidStack newStack = this.getStack().copy();
            newStack.amount = runningStackSize;
            stackList.add(newStack);
        }
        return stackList;
    }

    @Override
    public boolean matches(Object object, IngredientSorption sorption) {
        return this.ingredient.matches(object, sorption);
    }

    @Override
    public boolean isValid() {
        return this.ingredient.isValid();
    }
}

