/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.fluid.ITileFluid;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ToggleInputTanksSeparatedPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    boolean inputTanksSeparated;

    public ToggleInputTanksSeparatedPacket() {
        this.messageValid = false;
    }

    public ToggleInputTanksSeparatedPacket(ITileFluid machine) {
        this.pos = machine.getTilePos();
        this.inputTanksSeparated = machine.getInputTanksSeparated();
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.inputTanksSeparated = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.inputTanksSeparated);
    }

    public static class Handler
    implements IMessageHandler<ToggleInputTanksSeparatedPacket, IMessage> {
        public IMessage onMessage(ToggleInputTanksSeparatedPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ToggleInputTanksSeparatedPacket message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile == null) {
                return;
            }
            if (tile instanceof ITileFluid) {
                ITileFluid machine = (ITileFluid)tile;
                machine.setInputTanksSeparated(message.inputTanksSeparated);
                ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos).func_70296_d();
            }
        }
    }
}

