/*
 * Decompiled with CFR 0.152.
 */
package nc.item.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import nc.ModCheck;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.sink.IRadiationSink;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.item.NCItem;
import nc.util.Lang;
import nc.util.UnitHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemRadiationBadge
extends NCItem
implements IBauble {
    private static final String EXPOSURE = Lang.localise("item.nuclearcraft.radiation_badge.exposure");
    private static final String BADGE_BROKEN = Lang.localise("item.nuclearcraft.radiation_badge.broken");

    public ItemRadiationBadge(String nameIn, String ... tooltip) {
        super(nameIn, tooltip);
        this.field_77777_bU = 1;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.CHARM;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!stack.hasCapability(IRadiationSink.CAPABILITY_RADIATION_SINK, null)) {
            return false;
        }
        IRadiationSink radiation = (IRadiationSink)stack.getCapability(IRadiationSink.CAPABILITY_RADIATION_SINK, null);
        if (radiation == null) {
            return false;
        }
        return radiation.getRadiationLevel() > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.hasCapability(IRadiationSink.CAPABILITY_RADIATION_SINK, null)) {
            return 0.0;
        }
        IRadiationSink badge = (IRadiationSink)stack.getCapability(IRadiationSink.CAPABILITY_RADIATION_SINK, null);
        if (badge == null) {
            return 0.0;
        }
        return MathHelper.func_151237_a((double)(badge.getRadiationLevel() / NCConfig.radiation_badge_durability), (double)0.0, (double)1.0);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!ModCheck.baublesLoaded() && entity instanceof EntityPlayer) {
            this.updateBadge(stack, (EntityPlayer)entity);
        }
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.updateBadge(stack, (EntityPlayer)entity);
        }
    }

    private void updateBadge(ItemStack stack, EntityPlayer player) {
        if (player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            IEntityRads entityRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (entityRads == null || entityRads.isRadiationUndetectable() || !stack.hasCapability(IRadiationSink.CAPABILITY_RADIATION_SINK, null)) {
                return;
            }
            IRadiationSink badge = (IRadiationSink)stack.getCapability(IRadiationSink.CAPABILITY_RADIATION_SINK, null);
            if (badge == null) {
                return;
            }
            int infoCount = MathHelper.func_76128_c((double)(badge.getRadiationLevel() / (NCConfig.radiation_badge_info_rate * NCConfig.radiation_badge_durability)));
            badge.setRadiationLevel(badge.getRadiationLevel() + entityRads.getRadiationLevel());
            World world = player.func_130014_f_();
            if (badge.getRadiationLevel() >= NCConfig.radiation_badge_durability) {
                if (!world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + EXPOSURE + " " + UnitHelper.prefix(badge.getRadiationLevel(), 3, "Rads")));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + BADGE_BROKEN));
                } else {
                    player.func_184185_a(SoundHandler.chems_wear_off, 0.65f, 1.0f);
                }
                stack.func_190918_g(1);
            } else if (!world.field_72995_K && infoCount != MathHelper.func_76128_c((double)(badge.getRadiationLevel() / (NCConfig.radiation_badge_info_rate * NCConfig.radiation_badge_durability)))) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + EXPOSURE + " " + UnitHelper.prefix(badge.getRadiationLevel(), 3, "Rads")));
            }
        }
    }
}

