/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.item.NCItem;
import nc.util.Lang;
import nc.util.UnitHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemRadX
extends NCItem {
    private static final String RAD_X_COOLDOWN = Lang.localise("message.nuclearcraft.rad_x_cooling_down");

    public ItemRadX(String nameIn, String ... tooltip) {
        super(nameIn, tooltip);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
                return stack;
            }
            IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (playerRads == null) {
                return stack;
            }
            if (playerRads.canConsumeRadX()) {
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundHandler.rad_x, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.onRadawayConsumed(stack, world, player);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
                }
                stack.func_190918_g(1);
                playerRads.setConsumedMedicine(true);
                playerRads.setRadXCooldown(NCConfig.radiation_rad_x_cooldown);
                if (NCConfig.radiation_rad_x_cooldown >= 10.0) {
                    this.sendCooldownMessage(world, player, playerRads, false);
                }
            } else {
                playerRads.setConsumedMedicine(false);
            }
        }
        return stack;
    }

    private void sendCooldownMessage(World world, EntityPlayer player, IEntityRads playerRads, boolean playSound) {
        if (playerRads.getRadXCooldown() > 0.0) {
            if (playSound && world.field_72995_K) {
                player.func_184185_a(SoundHandler.chems_wear_off, 0.5f, 1.0f);
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + RAD_X_COOLDOWN + " " + UnitHelper.applyTimeUnitShort(Math.ceil(playerRads.getRadXCooldown()), 2, 1)));
            }
        }
    }

    private void onRadawayConsumed(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || !player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return;
        }
        IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (playerRads == null) {
            return;
        }
        playerRads.setRadiationResistance(playerRads.getRadiationResistance() + NCConfig.radiation_rad_x_amount);
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return this.actionResult(false, stack);
        }
        IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (playerRads == null) {
            return this.actionResult(false, stack);
        }
        if (!playerRads.canConsumeRadX()) {
            playerRads.setConsumedMedicine(false);
            this.sendCooldownMessage(world, player, playerRads, true);
            return this.actionResult(false, stack);
        }
        player.func_184598_c(hand);
        return this.actionResult(true, stack);
    }
}

