/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.tconstruct;

import nc.NuclearCraft;
import nc.config.NCConfig;
import nc.integration.tconstruct.TConstructHelper;
import nc.integration.tconstruct.trait.NCTraits;
import net.minecraftforge.fluids.FluidRegistry;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TConstructMaterials {
    public static void init() {
        if (NCConfig.tool_tic_register[0] || NCConfig.armor_conarm_register[0]) {
            TConstructMaterials.registerMaterial("boron", "Boron", "ingotBoron", "boron", true, new ITrait[]{TinkerTraits.dense, TinkerTraits.stiff}, new ITrait[]{TinkerTraits.stiff}, 0x6C6C6C, 0x7D7D7D, 0x959595, false, 0);
        }
        if (NCConfig.tool_tic_register[1] || NCConfig.armor_conarm_register[1]) {
            TConstructMaterials.registerMaterial("tough", "Tough", "ingotTough", "tough", true, new ITrait[]{TinkerTraits.dense, TinkerTraits.momentum}, new ITrait[]{TinkerTraits.dense}, 1314335, 1380129, 0x171221, false, 1);
        }
        if (NCConfig.tool_tic_register[2] || NCConfig.armor_conarm_register[2]) {
            TConstructMaterials.registerMaterial("hard_carbon", "HardCarbon", "ingotHardCarbon", "hard_carbon", true, new ITrait[]{TinkerTraits.lightweight, TinkerTraits.sharp}, new ITrait[]{TinkerTraits.lightweight}, 796751, 1661296, 2259057, false, 2);
        }
        if (NCConfig.tool_tic_register[3] || NCConfig.armor_conarm_register[3]) {
            TConstructMaterials.registerMaterial("boron_nitride", "BoronNitride", "gemBoronNitride", null, false, new ITrait[]{TinkerTraits.jagged, TinkerTraits.splintering}, new ITrait[]{TinkerTraits.splintering}, -831147415, -831147415, -831147415, true, 3);
        }
        if (NCConfig.tool_tic_register[4] || NCConfig.armor_conarm_register[4]) {
            TConstructMaterials.registerMaterial("thorium", "Thorium", "ingotThorium", "thorium", true, new ITrait[]{NCTraits.WITHERING}, new ITrait[]{TinkerTraits.poisonous, NCTraits.WITHERING}, 0x222222, 0x292929, 0x2E2E2E, false, 225, 9.0, 2.5, 2, 0.75);
        }
        if (NCConfig.tool_tic_register[5] || NCConfig.armor_conarm_register[5]) {
            TConstructMaterials.registerMaterial("uranium", "Uranium", "ingotUranium", "uranium", true, new ITrait[]{TinkerTraits.poisonous}, new ITrait[]{TinkerTraits.poisonous, NCTraits.WITHERING}, 0x344F33, 4219712, 5008204, false, 242, 7.5, 2.0, 2, 0.8);
        }
        if (NCConfig.tool_tic_register[6] || NCConfig.armor_conarm_register[6]) {
            TConstructMaterials.registerMaterial("magnesium", "Magnesium", "ingotMagnesium", "magnesium", true, new ITrait[]{TinkerTraits.holy, TinkerTraits.lightweight}, new ITrait[]{TinkerTraits.lightweight}, 12097717, 14925279, 16244729, false, 197, 11.0, 1.5, 1, 1.0);
        }
        if (NCConfig.tool_tic_register[7] || NCConfig.armor_conarm_register[7]) {
            TConstructMaterials.registerMaterial("chocolate", "Chocolate", "ingotChocolate", "milk_chocolate", true, new ITrait[]{NCTraits.MOLDABLE_II, TinkerTraits.tasty}, new ITrait[]{NCTraits.MOLDABLE_I, NCTraits.UPLIFTING}, 5052426, 5774860, 6431502, false, 32, 2.0, 0.0, 0, 0.15);
        }
    }

    private static void registerMaterial(String materialName, String oreSuffix, String repairItem, String fluidName, boolean casted, ITrait[] headTraits, ITrait[] extraTraits, int colorLow, int colorMed, int colorHigh, boolean transparent, int durability, double miningSpeed, double attackDamage, int miningLevel, double handleModifier) {
        for (MaterialIntegration matInteg : TinkerRegistry.getMaterialIntegrations()) {
            if (matInteg == null || matInteg.material == null || matInteg.material.getIdentifier() != materialName) continue;
            return;
        }
        if (TinkerRegistry.getMaterial((String)materialName) != Material.UNKNOWN) {
            return;
        }
        Material material = new Material(materialName, colorMed);
        for (ITrait headTrait : headTraits) {
            material.addTrait(headTrait);
        }
        for (ITrait extraTrait : extraTraits) {
            material.addTrait(extraTrait, "handle");
            material.addTrait(extraTrait, "extra");
        }
        material.addItem(repairItem, 1, 144);
        material.setCraftable(!casted).setCastable(casted);
        if (transparent) {
            NuclearCraft.proxy.setRenderInfo(material, colorMed);
        } else {
            NuclearCraft.proxy.setRenderInfo(material, colorLow, colorMed, colorHigh);
        }
        material.setFluid(fluidName == null ? null : FluidRegistry.getFluid((String)fluidName));
        TConstructHelper.addMaterialStats(material, new IMaterialStats[]{new HeadMaterialStats((int)((double)durability * 0.8), (float)miningSpeed, 2.0f + (float)attackDamage, miningLevel), new HandleMaterialStats((float)handleModifier, (int)((double)durability * (casted ? 0.25 : 0.1))), new ExtraMaterialStats((int)((double)durability * (casted ? 0.0375 : 0.0625) / handleModifier)), new BowMaterialStats((float)(handleModifier / 2.0), (float)(handleModifier * 2.0), 2.0f + (float)attackDamage)});
        TConstructMaterials.integrateMaterial(material, oreSuffix, casted);
        material.setRepresentativeItem(repairItem);
    }

    private static void registerMaterial(String materialName, String oreSuffix, String repairItem, String fluidName, boolean casted, ITrait[] headTraits, ITrait[] extraTraits, int colorLow, int colorMed, int colorHigh, boolean transparent, int toolNumber) {
        TConstructMaterials.registerMaterial(materialName, oreSuffix, repairItem, fluidName, casted, headTraits, extraTraits, colorLow, colorMed, colorHigh, transparent, NCConfig.tool_durability[2 * toolNumber], NCConfig.tool_speed[2 * toolNumber], NCConfig.tool_attack_damage[2 * toolNumber], NCConfig.tool_mining_level[2 * toolNumber], NCConfig.tool_handle_modifier[toolNumber]);
    }

    private static void integrateMaterial(Material material, String oreSuffix, boolean toolForge) {
        MaterialIntegration matInteg = material.getFluid() != null ? new MaterialIntegration(material, material.getFluid(), oreSuffix) : new MaterialIntegration(material);
        if (toolForge) {
            matInteg = matInteg.toolforge();
        }
        TinkerRegistry.integrate((MaterialIntegration)matInteg).preInit();
    }
}

