/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.source;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import nc.radiation.RadSources;
import nc.util.ItemInfo;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class RadiationSourceStackProvider
implements ICapabilityProvider {
    private IRadiationSource radiation = null;
    private final ItemStack stack;

    public RadiationSourceStackProvider(ItemStack stack) {
        this.stack = stack;
    }

    private IRadiationSource getRadiation() {
        if (this.radiation == null) {
            ItemInfo itemInfo = new ItemInfo(this.stack);
            if (RadSources.STACK_MAP.containsKey(itemInfo)) {
                this.radiation = new RadiationSource(RadSources.STACK_MAP.get(itemInfo));
            } else {
                for (String oreName : OreDictHelper.getOreNames(this.stack)) {
                    if (!RadSources.ORE_MAP.containsKey(oreName)) continue;
                    this.radiation = new RadiationSource(RadSources.ORE_MAP.get(oreName));
                    break;
                }
            }
            if (this.radiation == null) {
                this.radiation = new RadiationSource(0.0);
            }
        }
        return this.radiation;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)IRadiationSource.CAPABILITY_RADIATION_SOURCE.cast((Object)this.getRadiation());
        }
        return null;
    }
}

