/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation;

import nc.capability.radiation.entity.EntityRadsProvider;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.resistance.RadiationResistanceProvider;
import nc.capability.radiation.resistance.RadiationResistanceStackProvider;
import nc.capability.radiation.sink.IRadiationSink;
import nc.capability.radiation.sink.RadiationSinkProvider;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSourceProvider;
import nc.capability.radiation.source.RadiationSourceStackProvider;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.radiation.RadWorlds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RadiationCapabilityHandler {
    @SubscribeEvent
    public void attachEntityRadiationCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(IEntityRads.CAPABILITY_ENTITY_RADS_NAME, (ICapabilityProvider)new EntityRadsProvider(NCConfig.max_player_rads));
        } else if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(IEntityRads.CAPABILITY_ENTITY_RADS_NAME, (ICapabilityProvider)new EntityRadsProvider(50.0 * (double)((EntityLivingBase)event.getObject()).func_110143_aJ()));
        }
    }

    @SubscribeEvent
    public void attachChunkRadiationCapability(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceProvider(0.0));
    }

    @SubscribeEvent
    public void attachWorldRadiationCapability(AttachCapabilitiesEvent<World> event) {
        int dim = ((World)event.getObject()).field_73011_w.getDimension();
        if (RadWorlds.RAD_MAP.containsKey(dim)) {
            event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceProvider(RadWorlds.RAD_MAP.get(dim)));
            return;
        }
    }

    @SubscribeEvent
    public void attachTileRadiationCapability(AttachCapabilitiesEvent<TileEntity> event) {
        event.addCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE_NAME, (ICapabilityProvider)new RadiationResistanceProvider(0.0));
    }

    @SubscribeEvent
    public void attachStackRadiationCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_190926_b()) {
            return;
        }
        event.addCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE_NAME, (ICapabilityProvider)new RadiationSourceStackProvider(stack));
        if (stack.func_77973_b() == NCItems.radiation_badge) {
            event.addCapability(IRadiationSink.CAPABILITY_RADIATION_SINK_NAME, (ICapabilityProvider)new RadiationSinkProvider(0.0));
        }
        event.addCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE_NAME, (ICapabilityProvider)new RadiationResistanceStackProvider(stack));
    }
}

