/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import com.google.common.collect.Multimap;
import drzhark.mocreatures.item.MoCItem;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class MoCItemWeapon
extends MoCItem {
    private float attackDamage;
    private final Item.ToolMaterial material;
    private int specialWeaponType = 0;
    private boolean breakable = false;

    public MoCItemWeapon(String name, Item.ToolMaterial par2ToolMaterial) {
        super(name);
        this.material = par2ToolMaterial;
        this.field_77777_bU = 1;
        this.func_77656_e(par2ToolMaterial.func_77997_a());
        this.attackDamage = 4.0f + par2ToolMaterial.func_78000_c();
    }

    public MoCItemWeapon(String name, Item.ToolMaterial par2ToolMaterial, int damageType, boolean fragile) {
        this(name, par2ToolMaterial);
        this.specialWeaponType = damageType;
        this.breakable = fragile;
    }

    public float getAttackDamage() {
        return this.material.func_78000_c();
    }

    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase target, EntityLivingBase attacker) {
        int i = 1;
        if (this.breakable) {
            i = 10;
        }
        par1ItemStack.func_77972_a(i, attacker);
        int potionTime = 100;
        switch (this.specialWeaponType) {
            case 1: {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, potionTime, 0));
                break;
            }
            case 2: {
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, potionTime, 0));
                break;
            }
            case 3: {
                target.func_70015_d(10);
                break;
            }
            case 4: {
                target.func_70690_d(new PotionEffect(MobEffects.field_76431_k, potionTime, 0));
                break;
            }
            case 5: {
                target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, potionTime, 0));
                break;
            }
        }
        return true;
    }

    public boolean onBlockDestroyed(ItemStack par1ItemStack, int par2, int par3, int par4, int par5, EntityLiving par6EntityLiving) {
        par1ItemStack.func_77972_a(2, (EntityLivingBase)par6EntityLiving);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150321_G;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase playerIn) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, playerIn);
        }
        return true;
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        }
        return multimap;
    }
}

