/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import drzhark.customspawner.utils.CMSUtils;
import drzhark.mocreatures.util.MoCLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class MoCDespawner {
    public static boolean debug = false;
    public static int despawnLightLevel = 7;
    public static int despawnTickRate = 111;
    public List<Biome> biomeList = new ArrayList<Biome>();
    private List<Class<? extends EntityLiving>> vanillaClassList;

    public MoCDespawner() {
        try {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null) continue;
                this.biomeList.add(biome);
            }
            this.vanillaClassList = new ArrayList<Class<? extends EntityLiving>>();
            this.vanillaClassList.add(EntityChicken.class);
            this.vanillaClassList.add(EntityCow.class);
            this.vanillaClassList.add(EntityPig.class);
            this.vanillaClassList.add(EntitySheep.class);
            this.vanillaClassList.add(EntityWolf.class);
            this.vanillaClassList.add(EntitySquid.class);
            this.vanillaClassList.add(EntityOcelot.class);
            this.vanillaClassList.add(EntityBat.class);
            this.vanillaClassList.add(EntityHorse.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static final int entityDespawnCheck(WorldServer world, EntityLiving entityliving, int minDespawnLightLevel, int maxDespawnLightLevel) {
        if (entityliving instanceof EntityWolf && ((EntityWolf)entityliving).func_70909_n()) {
            return 0;
        }
        if (entityliving instanceof EntityOcelot && ((EntityOcelot)entityliving).func_70909_n()) {
            return 0;
        }
        if (!MoCDespawner.isValidDespawnLightLevel((Entity)entityliving, (World)world, minDespawnLightLevel, maxDespawnLightLevel)) {
            return 0;
        }
        EntityPlayer entityplayer = world.func_72890_a((Entity)entityliving, -1.0);
        if (entityplayer != null) {
            double d = entityplayer.field_70165_t - entityliving.field_70165_t;
            double d1 = entityplayer.field_70163_u - entityliving.field_70163_u;
            double d2 = entityplayer.field_70161_v - entityliving.field_70161_v;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0) {
                entityliving.func_70106_y();
                return 1;
            }
            if (entityliving.func_70654_ax() > 600 && world.field_73012_v.nextInt(800) == 0 && !(d3 < 1024.0)) {
                entityliving.func_70106_y();
                return 1;
            }
        }
        return 0;
    }

    public static final int despawnVanillaAnimals(WorldServer world, int minDespawnLightLevel, int maxDespawnLightLevel) {
        int count = 0;
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!(entity instanceof EntityLiving) || !(entity instanceof EntityHorse) && !(entity instanceof EntityCow) && !(entity instanceof EntitySheep) && !(entity instanceof EntityPig) && !(entity instanceof EntityOcelot) && !(entity instanceof EntityChicken) && !(entity instanceof EntitySquid) && !(entity instanceof EntityWolf) && !(entity instanceof EntityMooshroom)) continue;
            count += MoCDespawner.entityDespawnCheck(world, (EntityLiving)entity, minDespawnLightLevel, maxDespawnLightLevel);
        }
        return count;
    }

    public final int countEntities(Class<? extends EntityLiving> class1, World world) {
        int i = 0;
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public static boolean isValidLightLevel(Entity entity, WorldServer world, int lightLevel, boolean checkAmbientLightLevel) {
        if (entity.isCreatureType(EnumCreatureType.MONSTER, false)) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.AMBIENT, false) && !checkAmbientLightLevel) {
            return true;
        }
        if (!entity.isCreatureType(EnumCreatureType.CREATURE, false)) {
            return true;
        }
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int i = 0;
        if (y >= 0) {
            if (y >= 256) {
                y = 255;
            }
            i = MoCDespawner.getLightFromNeighbors(world.func_72964_e(x >> 4, z >> 4), x & 0xF, y, z & 0xF);
        }
        if (i > lightLevel && debug) {
            MoCLog.logger.info("Denied spawn! for " + entity.func_70005_c_() + ". LightLevel over threshold of " + lightLevel + " in dimension " + world.field_73011_w.func_186058_p().func_186068_a() + " at coords " + x + ", " + y + ", " + z);
        }
        return i <= lightLevel;
    }

    public static boolean isValidDespawnLightLevel(Entity entity, World world, int minDespawnLightLevel, int maxDespawnLightLevel) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int blockLightLevel = 0;
        if (y >= 0) {
            if (y >= 256) {
                y = 255;
            }
            blockLightLevel = CMSUtils.getLightFromNeighbors((Chunk)world.func_72964_e(x >> 4, z >> 4), (int)(x & 0xF), (int)y, (int)(z & 0xF));
        }
        if (blockLightLevel < minDespawnLightLevel && maxDespawnLightLevel != -1) {
            return false;
        }
        return blockLightLevel <= maxDespawnLightLevel || maxDespawnLightLevel == -1;
    }

    public static int getLightFromNeighbors(Chunk chunk, int x, int y, int z) {
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
        if (extendedblockstorage == null) {
            return 0;
        }
        return extendedblockstorage.func_76674_d(x, y & 0xF, z);
    }
}

