/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.StateSelectOptimizer;
import java.util.Collection;

public class StateSelect {
    private static boolean useOptimizer = false;
    private final StateExpression[] expressions;
    private final AnimationState.StateKey[] programKeys;
    private final short[] programCodes;
    public static final StateSelect EMPTY = new StateSelect(new StateExpression[0]);
    static final int CODE_RESULT = 32768;
    static final int CODE_MASK = Short.MAX_VALUE;

    public StateSelect(Collection<StateExpression> expressions) {
        this(expressions.toArray(new StateExpression[expressions.size()]));
    }

    public StateSelect(StateExpression ... expressions) {
        StateSelectOptimizer sso;
        this.expressions = expressions;
        StateSelectOptimizer stateSelectOptimizer = sso = useOptimizer ? StateSelectOptimizer.optimize(expressions) : null;
        if (sso != null) {
            this.programKeys = sso.programKeys;
            this.programCodes = sso.programCodes;
        } else {
            this.programKeys = null;
            this.programCodes = null;
        }
    }

    public static boolean isUseOptimizer() {
        return useOptimizer;
    }

    public static void setUseOptimizer(boolean useOptimizer) {
        StateSelect.useOptimizer = useOptimizer;
    }

    public int getNumExpressions() {
        return this.expressions.length;
    }

    public StateExpression getExpression(int idx) {
        return this.expressions[idx];
    }

    public int evaluate(AnimationState as) {
        if (this.programKeys != null) {
            return this.evaluateProgram(as);
        }
        return this.evaluateExpr(as);
    }

    private int evaluateExpr(AnimationState as) {
        int i;
        int n = this.expressions.length;
        for (i = 0; i < n && !this.expressions[i].evaluate(as); ++i) {
        }
        return i;
    }

    private int evaluateProgram(AnimationState as) {
        int pos = 0;
        do {
            if (as != null && as.getAnimationState(this.programKeys[pos >> 1])) continue;
            ++pos;
        } while ((pos = this.programCodes[pos]) >= 0);
        return pos & Short.MAX_VALUE;
    }
}

