/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.items.ItemPotionEssence;
import xreliquary.util.potions.EffectComparator;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.PotionMap;

public class XRPotionHelper {
    private static final String EFFECTS_NBT_TAG = "effects";
    private static int MAX_DURATION = 36000;
    private static int MAX_AMPLIFIER = 4;
    private static Potion[] nonAugmentableEffects = new Potion[]{MobEffects.field_76440_q, MobEffects.field_76431_k, MobEffects.field_76441_p, MobEffects.field_76439_r, MobEffects.field_76427_o};

    public static boolean isItemEssence(ItemStack ist) {
        return ist.func_77973_b() instanceof ItemPotionEssence;
    }

    public static boolean isItemIngredient(ItemStack ist) {
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!ingredient.item.func_77973_b().getRegistryName().equals((Object)ist.func_77973_b().getRegistryName()) || ingredient.item.func_77960_j() != ist.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static PotionIngredient getIngredient(ItemStack ist) {
        if (ist.func_77973_b() instanceof ItemPotionEssence) {
            return new PotionIngredient(ist, XRPotionHelper.getPotionEffectsFromStack(ist));
        }
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!ingredient.item.func_77973_b().getRegistryName().equals((Object)ist.func_77973_b().getRegistryName()) || ingredient.item.func_77960_j() != ist.func_77960_j()) continue;
            return ingredient;
        }
        return null;
    }

    private static boolean isAugmentablePotionEffect(PotionEffect effect) {
        for (Potion nonAugmentableEffect : nonAugmentableEffects) {
            if (nonAugmentableEffect != effect.func_188419_a()) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void addPotionTooltip(List<PotionEffect> effects, List<String> list) {
        XRPotionHelper.addPotionTooltip(effects, list, true, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionTooltip(List<PotionEffect> effects, List<String> list, boolean displayWhenDrankInfo, boolean addFormatting) {
        if (!effects.isEmpty()) {
            ArrayList list1 = Lists.newArrayList();
            for (PotionEffect potioneffect : effects) {
                String s1 = I18n.func_135052_a((String)potioneffect.func_76453_d(), (Object[])new Object[0]).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + potioneffect.func_76458_c()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f) + ")";
                }
                if (potion.func_76398_f()) {
                    list.add((addFormatting ? TextFormatting.RED.toString() : "") + s1);
                    continue;
                }
                list.add((addFormatting ? TextFormatting.BLUE.toString() : "") + s1);
            }
            if (displayWhenDrankInfo && !list1.isEmpty()) {
                list.add("");
                list.add((addFormatting ? TextFormatting.DARK_PURPLE.toString() : "") + I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0]));
                for (Tuple tuple : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        list.add((addFormatting ? TextFormatting.BLUE.toString() : "") + I18n.func_135052_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add((addFormatting ? TextFormatting.RED.toString() : "") + I18n.func_135052_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionTooltip(ItemStack stack, List<String> list) {
        XRPotionHelper.addPotionTooltip(XRPotionHelper.getPotionEffectsFromStack(stack), list);
    }

    public static void addPotionEffectsToCompoundTag(@Nonnull NBTTagCompound tag, Collection<PotionEffect> effects) {
        if (effects == null || effects.isEmpty()) {
            return;
        }
        NBTTagList effectList = tag.func_150295_c(EFFECTS_NBT_TAG, 10);
        for (PotionEffect object : effects) {
            NBTTagCompound effect = new NBTTagCompound();
            effect.func_74778_a("name", object.func_188419_a().getRegistryName().toString());
            effect.func_74768_a("duration", object.func_188419_a().func_76403_b() ? 1 : object.func_76459_b());
            effect.func_74768_a("potency", object.func_76458_c());
            effectList.func_74742_a((NBTBase)effect);
        }
        tag.func_74782_a(EFFECTS_NBT_TAG, (NBTBase)effectList);
    }

    public static List<PotionEffect> getPotionEffectsFromCompoundTag(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b(EFFECTS_NBT_TAG)) {
            return Lists.newArrayList();
        }
        NBTTagList effectList = tag.func_150295_c(EFFECTS_NBT_TAG, 10);
        ArrayList ret = Lists.newArrayList();
        for (NBTBase effectTag : effectList) {
            NBTTagCompound effect = (NBTTagCompound)effectTag;
            String registryName = effect.func_74779_i("name");
            int duration = effect.func_74762_e("duration");
            int potency = effect.func_74762_e("potency");
            ret.add(new PotionEffect(Potion.func_180142_b((String)registryName), duration, potency));
        }
        return ret;
    }

    public static List<PotionEffect> getPotionEffectsFromStack(ItemStack stack) {
        return XRPotionHelper.getPotionEffectsFromCompoundTag(stack.func_77978_p());
    }

    public static void addPotionEffectsToStack(ItemStack itemstack, List<PotionEffect> effects) {
        NBTTagCompound tag = (NBTTagCompound)MoreObjects.firstNonNull((Object)itemstack.func_77978_p(), (Object)new NBTTagCompound());
        XRPotionHelper.addPotionEffectsToCompoundTag(tag, effects);
        itemstack.func_77982_d(tag);
    }

    public static void cleanPotionEffects(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b(EFFECTS_NBT_TAG)) {
            tag.func_82580_o(EFFECTS_NBT_TAG);
        }
    }

    public static List<PotionEffect> changePotionEffectsDuration(Collection<PotionEffect> effects, float factor) {
        ArrayList ret = Lists.newArrayList();
        for (PotionEffect effect : effects) {
            int newDuration = (int)(effect.func_188419_a().func_76403_b() ? 1.0f : (float)effect.func_76459_b() * factor);
            ret.add(new PotionEffect(effect.func_188419_a(), newDuration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
        return ret;
    }

    public static List<PotionEffect> augmentPotionEffects(List<PotionEffect> effects, int redstoneCount, int glowstoneCount) {
        return XRPotionHelper.addRedstone(XRPotionHelper.addGlowstone(effects, glowstoneCount), redstoneCount);
    }

    private static List<PotionEffect> addRedstone(List<PotionEffect> effects, int redstoneCount) {
        if (redstoneCount <= 0) {
            return effects;
        }
        ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>();
        int effectCnt = effects.size();
        double multiplier = 1.0;
        for (int redstoneLevel = 1; redstoneLevel <= redstoneCount; ++redstoneLevel) {
            multiplier *= (double)(8 + effectCnt) / (double)(3 + effectCnt) - 1.0 / (double)(3 + effectCnt) * ((double)redstoneLevel - 1.0);
        }
        for (PotionEffect effect : effects) {
            int newDuration = new Double((double)effect.func_76459_b() * multiplier).intValue();
            newDuration = Math.min(newDuration, MAX_DURATION * 2);
            PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), newDuration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
            newEffects.add(newEffect);
        }
        return newEffects;
    }

    private static List<PotionEffect> addGlowstone(List<PotionEffect> effects, int glowstoneCount) {
        if (glowstoneCount <= 0) {
            return effects;
        }
        ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>();
        int effectCnt = effects.size();
        double multiplier = 1.0;
        for (int glowstoneLevel = 1; glowstoneLevel <= glowstoneCount; ++glowstoneLevel) {
            multiplier *= (double)(11 + effectCnt) / (double)(6 + effectCnt) - 1.0 / (double)(6 + effectCnt) * (double)glowstoneLevel - 1.0;
        }
        for (PotionEffect effect : effects) {
            int newAmplifier = effect.func_76458_c();
            if (XRPotionHelper.isAugmentablePotionEffect(effect)) {
                newAmplifier = Math.min(effect.func_76458_c() + glowstoneCount, MAX_AMPLIFIER + 1);
            }
            PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), new Double((double)effect.func_76459_b() * multiplier).intValue(), newAmplifier, effect.func_82720_e(), effect.func_188418_e());
            newEffects.add(newEffect);
        }
        return newEffects;
    }

    static List<PotionEffect> combineIngredients(PotionIngredient ... ingredients) {
        return XRPotionHelper.combineIngredients(Arrays.asList(ingredients));
    }

    public static List<PotionEffect> combineIngredients(Collection<PotionIngredient> ingredients) {
        HashMap potionEffectCounterList = new HashMap();
        ArrayList<ResourceLocation> potionEffectList = new ArrayList<ResourceLocation>();
        for (PotionIngredient ingredient : ingredients) {
            for (PotionEffect effect : ingredient.getEffects()) {
                if (potionEffectCounterList.keySet().contains(effect.func_188419_a().getRegistryName())) {
                    if (!potionEffectList.contains(effect.func_188419_a().getRegistryName())) {
                        potionEffectList.add(effect.func_188419_a().getRegistryName());
                    }
                    ((List)potionEffectCounterList.get(effect.func_188419_a().getRegistryName())).add(effect);
                    continue;
                }
                ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                effects.add(effect);
                potionEffectCounterList.put(effect.func_188419_a().getRegistryName(), effects);
            }
        }
        ArrayList combinedEffects = Lists.newArrayList();
        for (ResourceLocation potionName : potionEffectList) {
            Potion potion;
            List effects = (List)potionEffectCounterList.get(potionName);
            int duration = XRPotionHelper.getCombinedDuration(effects);
            int amplifier = XRPotionHelper.getCombinedAmplifier(effects);
            if (duration == 0 || (potion = (Potion)Potion.field_188414_b.func_82594_a((Object)potionName)) == null) continue;
            combinedEffects.add(new PotionEffect(potion, duration, amplifier));
        }
        combinedEffects.sort(new EffectComparator());
        return combinedEffects;
    }

    private static int getCombinedAmplifier(List<PotionEffect> effects) {
        int amplifier = 0;
        for (PotionEffect effect : effects) {
            amplifier += effect.func_76458_c();
        }
        return Math.min(amplifier, MAX_AMPLIFIER);
    }

    private static int getCombinedDuration(List<PotionEffect> effects) {
        int count = 0;
        int duration = 0;
        for (PotionEffect effect : effects) {
            if (effect.func_188419_a().func_76403_b()) {
                return 1;
            }
            ++count;
            duration += effect.func_76459_b();
        }
        duration = (int)((double)duration / 1.2);
        if (count == 3) {
            duration = (int)((double)duration / 1.1);
        }
        return Math.min(duration, MAX_DURATION);
    }

    public static void applyEffectsToEntity(Collection<PotionEffect> effects, Entity source, Entity indirectSource, EntityLivingBase entitylivingbase) {
        XRPotionHelper.applyEffectsToEntity(effects, source, indirectSource, entitylivingbase, 1.0);
    }

    public static void applyEffectsToEntity(Collection<PotionEffect> effects, Entity source, Entity indirectSource, EntityLivingBase entitylivingbase, double amplifier) {
        for (PotionEffect potioneffect : effects) {
            if (potioneffect.func_188419_a().func_76403_b()) {
                potioneffect.func_188419_a().func_180793_a(source, indirectSource, entitylivingbase, potioneffect.func_76458_c(), amplifier);
                continue;
            }
            int j = (int)(amplifier * (double)potioneffect.func_76459_b() + 0.5);
            if (j <= 20) continue;
            entitylivingbase.func_70690_d(new PotionEffect(potioneffect.func_188419_a(), j, potioneffect.func_76458_c(), false, false));
        }
    }
}

